package ru.yandex.autotests.directapi.images.adimage;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.common.api45.AdImageActionResult;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.text.SimpleDateFormat;
import java.util.*;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;

/**
 * User: mariabye
 * Date: 23.05.13
 *
 * parallel-method = methods
 * thread-count = 2
 */

//https://jira.yandex-team.ru/browse/TESTIRT-1353
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_GET_LIMITS)
@RunWith(Parameterized.class)
public class UploadImagePoolSizeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String agencyLogin = Logins.AGENCY_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int POOL_SIZE = 1;

    @Parameterized.Parameter
    public String operator;
    @Parameterized.Parameter(value = 1)
    public String login;

    @Parameterized.Parameters(name = "operator = {0}")
    public static Collection roleValues() {
        // yip => yndx-images-pool
        String loginBase = "yip" + new SimpleDateFormat("yyMMddHHmmss").format(new Date());

        User user = api.as(agencyLogin).userSteps.addAgencySubClient(agencyLogin,loginBase, Currency.RUB);
        String login1 = user.getLogin();
        api.userSteps.clientFakeSteps().setImagePoolLimit(login1, POOL_SIZE);
        Calendar.getInstance();

        user = api.as(agencyLogin).userSteps.addAgencySubClient(agencyLogin,loginBase, Currency.RUB);
        String login2 = user.getLogin();
        api.userSteps.clientFakeSteps().setImagePoolLimit(login2, POOL_SIZE);
        Object[][] data = new Object[][]{
                {agencyLogin, login1},
                {Logins.SUPPORT, login2}
        };
        return Arrays.asList(data);
    }

    @Before
    public void deleteImages(){
        api.as(Logins.SUPER_LOGIN).userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7393")
    public void uploadRawImagesExceedPool() {
        log.info("Заполнение полностью стека картинками");
        // https://jira.yandex-team.ru/browse/DIRECT-32989
        for (int i = 0; i < POOL_SIZE+2; i++) {
            api.as(operator).userSteps.imagesSteps().uploadRawImage("my",ImagesSteps.getDefaultImageUrl(i + 1, ImageType.REGULAR),login);
        }
        log.info("Добавление картинки при заполненном стеке");
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                RandomStringUtils.randomAlphabetic(10), ImagesSteps.getDefaultImageUrl(POOL_SIZE+1, ImageType.REGULAR),login
        );

        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(273, null)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7394")
    public void uploadUrlImagesExceedPool() {
        log.info("Заполнение полностью стека картинками");

        AdImageResponse response = api.as(operator).userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR))
                        .withLogin(login),
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(2, ImageType.REGULAR))
                        .withLogin(login),
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR))
                        .withLogin(login)
        );

        List<Integer> taskIDs =
                extract(response.getActionsResult(), on(AdImageActionResult.class).getAdImageUploadTaskID());
        taskIDs.remove(null);
        int[] tasks = ArrayUtils.toPrimitive(taskIDs.toArray(new Integer[0]));
        api.userSteps.imagesSteps().waitForImageHandleResult(login,tasks);

        response = api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR))
                        .withLogin(login)
        );

        api.as(operator).userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(273)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7395")
    public void uploadUrlImagesExceedPoolAtOnce() {
        AdImageResponse response = api.as(operator).userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(5, ImageType.REGULAR))
                        .withLogin(login),
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(6, ImageType.REGULAR))
                        .withLogin(login),
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(1, ImageType.WIDE))
                        .withLogin(login),
                new AdImageURLMap(api.type())
                        .withName(RandomStringUtils.randomAlphabetic(10))
                        .withURL(ImagesSteps.getDefaultImageUrl(2, ImageType.WIDE))
                        .withLogin(login)
        );
        List<Integer> taskIDs =
                extract(response.getActionsResult(), on(AdImageActionResult.class).getAdImageUploadTaskID());
        taskIDs.remove(null);
        int[] tasks = ArrayUtils.toPrimitive(taskIDs.toArray(new Integer[0]));
        api.userSteps.imagesSteps().waitForImageHandleResult(login,tasks);
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(273)
        );
    }
}
