package ru.yandex.autotests.directapi.images.adimage.checkuploadstatus;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.ErrorMap;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.model.images.AdImageUploadMap;
import ru.yandex.autotests.directapi.model.images.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints.ignore;

/**
 * Created by ginger on 17.12.2015.
 * https://st.yandex-team.ru/TESTIRT-8018
 */
@Aqua.Test
@Feature(ImagesFeatures.AD_IMAGE_CHECK_UPLOAD_STATUS)
@Issue("https://st.yandex-team.ru/DIRECT-49536")
@Description("проверка корректой работы валидации при попытке загрузить невалидные картинки больших размеров")
@RunWith(Parameterized.class)
public class CheckUploadStatusBigImagesFailedTest {

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_7;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @BeforeClass
    public static void deleteAllImages() {
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String name;

    @Parameterized.Parameter(value = 1)
    public int taskID;

    @Parameterized.Parameter(value = 2)
    public ErrorMap error;

    @Parameterized.Parameters(name = "{0}")
    public static Collection roles() {
        api.as(Logins.SUPER_LOGIN).userSteps.imagesSteps().adImageDeleteForLogin(login);


        int[] taskIDs = api.as(login).userSteps.imagesSteps().putImageInUploadQueue(
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.invalidBigImages.get(1))
                        .withName(ImagesSteps.nameInvalidBigImages.get(1)),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.invalidBigImages.get(2))
                        .withName(ImagesSteps.nameInvalidBigImages.get(2)),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.invalidBigImages.get(3))
                        .withName(ImagesSteps.nameInvalidBigImages.get(3)),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.invalidBigImages.get(4))
                        .withName(ImagesSteps.nameInvalidBigImages.get(4)),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.invalidBigImages.get(5))
                        .withName(ImagesSteps.nameInvalidBigImages.get(5)),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.invalidBigImages.get(6))
                        .withName(ImagesSteps.nameInvalidBigImages.get(6))
        );

        Object[][] data = new Object[][]{
                {ImagesSteps.nameInvalidBigImages.get(1),
                        taskIDs[0],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                //до починки https://st.yandex-team.ru/DIRECT-51958
                {ImagesSteps.nameInvalidBigImages.get(2),
                        taskIDs[1],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {ImagesSteps.nameInvalidBigImages.get(3),
                        taskIDs[2],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {ImagesSteps.nameInvalidBigImages.get(4),
                        taskIDs[3],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {ImagesSteps.nameInvalidBigImages.get(5),
                        taskIDs[4],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {ImagesSteps.nameInvalidBigImages.get(6),
                        taskIDs[5],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_FORMAT_INVALID))}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8880")
    public void validateUploadError() {
        Object[] images = api.userSteps.imagesSteps().waitForImageHandleResult(login, taskID);

        AdImageUploadMap expectedImageState = new AdImageUploadMap(api.type())
                .withName(name)
                .withLogin(login)
                .withAdImageUploadTaskID(taskID)
                .withStatus(Status.ERROR)
                .withError(error);
        assertThat("отсутствуют URL и hash картинки в ответе",
                images[0], beanDiffer(expectedImageState.getBean()).fields(
                        ignore(AdImageUploadMap.AD_IMAGE_HASH, AdImageUploadMap.AD_IMAGE_URL, AdImageUploadMap.SOURCE_URL)));
    }
}
