package ru.yandex.autotests.directapi.images.adimage.checkuploadstatus;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.model.images.AdImageMap;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.model.images.AdImageUploadMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints.ignore;

/**
 * Created by ginger on 17.12.2015.
 * https://st.yandex-team.ru/TESTIRT-8018
 */
@Aqua.Test
@Feature(ImagesFeatures.AD_IMAGE_CHECK_UPLOAD_STATUS)
@Issue("https://st.yandex-team.ru/DIRECT-49536")
@Description("проверка корректной загрузки картинок больших размеров")
@RunWith(Parameterized.class)
public class CheckUploadStatusBigImagesSuccessTest {

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_8;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String name;

    @Parameterized.Parameter(value = 1)
    public int taskID;

    @Parameterized.Parameters(name = "{0}")
    public static Collection roles() {
        api.as(Logins.SUPER_LOGIN).userSteps.imagesSteps().adImageDeleteForLogin(login);

        try {
            Object[][] data = new Object[ImagesSteps.validRegularImages.size() + ImagesSteps.validWideImages.size()][];
            for (int i = 0; i < ImagesSteps.validRegularImages.size() + ImagesSteps.validWideImages.size(); i++) {
                if (i < ImagesSteps.validRegularImages.size()) {
                    int[] taskIDs = api.as(login).userSteps.imagesSteps().putImageInUploadQueue(
                            new AdImageURLMap<>(api.type())
                                    .withLogin(login)
                                    .withURL(ImagesSteps.validRegularImages.get(i + 1))
                                    .withName(ImagesSteps.nameValidRegularImages.get(i + 1)));

                    data[i] = new Object[]{ImagesSteps.nameValidRegularImages.get(i + 1),
                            taskIDs[0]};
                } else {
                    int[] taskIDs = api.as(login).userSteps.imagesSteps().putImageInUploadQueue(
                            new AdImageURLMap<>(api.type())
                                    .withLogin(login)
                                    .withURL(ImagesSteps.validWideImages.get(i + 1 - ImagesSteps.validRegularImages.size()))
                                    .withName(ImagesSteps.nameValidWideImages.get(i + 1 - ImagesSteps.validRegularImages.size())));

                    data[i] = new Object[]{ImagesSteps.nameValidWideImages.get(i + 1 - ImagesSteps.validRegularImages.size()),
                            taskIDs[0]};
                }
            }
                return Arrays.asList(data);
            }
         catch (Exception e) {
            throw new DirectAPIException("Ошибка при закгрузке картинок с URL", e);
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8881")
    public void validateUploadSuccess() {
        Object[] images = api.userSteps.imagesSteps().waitForImageHandleResult(login, taskID);

        AdImageUploadMap expectedImageState = new AdImageUploadMap(api.type())
                .withName(name)
                .withLogin(login)
                .withAdImageUploadTaskID(taskID)
                .withStatus(Status.DONE);

        BeanCompareStrategy strategy = new BeanCompareStrategy();
        strategy.putFieldMatcher(AdImageMap.AD_IMAGE_HASH, notNullValue());
        strategy.putFieldMatcher(AdImageMap.AD_IMAGE_URL, notNullValue());
        assertThat(images[0], beanDiffer(expectedImageState.getBean()).fields(
                ignore(AdImageUploadMap.AD_IMAGE_HASH, AdImageUploadMap.AD_IMAGE_URL, AdImageUploadMap.SOURCE_URL)));
    }
}
