package ru.yandex.autotests.directapi.images.adimage.checkuploadstatus;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.ErrorMap;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.model.images.AdImageUploadMap;
import ru.yandex.autotests.directapi.model.images.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static ru.yandex.autotests.direct.utils.matchers.BeanEqualsAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * User: mariabye
 * Date: 24.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_CHECK_UPLOAD_STATUS)
@RunWith(Parameterized.class)
public class CheckUploadStatusFailedTest {

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @BeforeClass
    public static void deleteAllImages() {
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String name;

    @Parameterized.Parameter(value = 1)
    public int taskID;

    @Parameterized.Parameter(value = 2)
    public ErrorMap error;

    @Parameterized.Parameters(name = "{0}")
    public static Collection roles() {
        api.as(Logins.SUPER_LOGIN).userSteps.imagesSteps().adImageDeleteForLogin(login);

        int[] taskIDs = api.as(login).userSteps.imagesSteps().putImageInUploadQueue(
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(1, ImageType.SMALL))
                        .withName("invalid pic 149x150"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(2, ImageType.SMALL))
                        .withName("invalid pic 150x149"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(3, ImageType.SMALL))
                        .withName("invalid pic 149x149"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(4, ImageType.SMALL))
                        .withName("invalid pic 150x201"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(5, ImageType.SMALL))
                        .withName("invalid pic 201x150"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(6, ImageType.SMALL))
                        .withName("invalid pic 150x150 bmp"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(7, ImageType.SMALL))
                        .withName("invalid pic 200x150 jpg"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(8, ImageType.SMALL))
                        .withName("invalid pic 180x150 gif"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(9, ImageType.SMALL))
                        .withName("invalid pic 150x150 png"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(10, ImageType.SMALL))
                        .withName("invalid pic 150x150 jpg"),
                new AdImageURLMap(api.type())
                        .withURL(ImagesSteps.getInvalidImageUrl(11, ImageType.SMALL))
                        .withName("invalid pic 150x200 jpg"),
                new AdImageURLMap(api.type())
                        .withURL("http://yandex.ru/123")
                        .withName("404 url = http://yandex.ru/123"),
                new AdImageURLMap(api.type())
                        .withURL("http://ya.ru/")
                        .withName("wrong content type: http://ya.ru/"),
                new AdImageURLMap(api.type())
                        .withURL("http://природа.рф/img/nature/0003.jpg")
                        .withName("wrong content type:природа.рф/img/nature/0003.jpg"),
                new AdImageURLMap(api.type())
                        .withURL(ValidImageData.getValidImageAdImage(1).getUrl())
                        .withName("image ad")
        );

        Object[][] data = new Object[][]{
                {"invalid pic 149x150",
                        taskIDs[0],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 150x149",
                        taskIDs[1],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 149x149",
                        taskIDs[2],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 150x201",
                        taskIDs[3],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 201x150",
                        taskIDs[4],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 150x150 bmp",
                        taskIDs[5],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_FORMAT_INVALID))},
                {"invalid pic 200x150 jpg",
                        taskIDs[6],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 180x150 gif",
                        taskIDs[7],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 150x150 png",
                        taskIDs[8],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 150x150 jpg",
                        taskIDs[9],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"invalid pic 200x150 jpg",
                        taskIDs[10],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"404 url = http://yandex.ru/123",
                        taskIDs[11],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_FILE_UPLOAD_ERROR_404))},
                {"wrong content type: http://ya.ru/",
                        taskIDs[12],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_FORMAT_INVALID))},
                {"wrong content type: " +
                        "http://природа.рф/img/nature/0003.jpg",
                        taskIDs[13],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
                {"image ad",
                        taskIDs[14],
                        new ErrorMap(api.type())
                                .withAxisError(new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID))},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7396")
    public void validateUploadError() {
        Object[] images = api.userSteps.imagesSteps().waitForImageHandleResult(taskID);

        AdImageUploadMap expectedImageState = new AdImageUploadMap(api.type())
                .withStatus(Status.ERROR)
                .withError(error);
        assertThat("вернулась правильная ошибка",
                images[0],
                beanDiffer(expectedImageState.getBean()).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
