package ru.yandex.autotests.directapi.images.adimage.checkuploadstatus;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.common.api45.AdImageUpload;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 24.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_CHECK_UPLOAD_STATUS)
public class CheckUploadStatusFilterTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int[] tasksIDs;

    @BeforeClass
    public static void initTest() {
        tasksIDs = api.as(login).userSteps.imagesSteps().configLoginTasks(login, new int[]{1, 2,3}, new int[0]);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7397")
    public void checkUploadStatusByUndefLogin() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
        );

        int[] gotTaskIDs = ImagesSteps.extractAdImageUploadTaskIDS(result.getAdImageUploads());
        assertThat("Неверный перечень taskIDs", gotTaskIDs, equalTo(tasksIDs));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7398")
    public void checkUploadStatusByEmptyLogin() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type()).withLogins(new String[]{})
                        .withAdImageUploadTaskIDS(tasksIDs)

        );

        int[] gotTaskIDs = ImagesSteps.extractAdImageUploadTaskIDS(result.getAdImageUploads());
        assertThat("Неверный перечень taskIDs", gotTaskIDs, equalTo(tasksIDs));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7399")
    public void checkUploadStatusByLogin() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type()).withLogins(new String[]{login})
                        .withAdImageUploadTaskIDS(tasksIDs)

        );

        int[] gotTaskIDs = ImagesSteps.extractAdImageUploadTaskIDS(result.getAdImageUploads());
        assertThat("Неверный перечень taskIDs", gotTaskIDs, equalTo(tasksIDs));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7400")
    public void clientCheckUploadStatusByNoRightLogin() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withLogins(new String[]{ImageLogins.CLIENT_SELF})
                        .withAdImageUploadTaskIDS(tasksIDs));

        int[] gotTaskIDs = ImagesSteps.extractAdImageUploadTaskIDS(result.getAdImageUploads());
        assertThat("Неверный перечень taskIDs", gotTaskIDs, equalTo(tasksIDs));
    }




    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7401")
    public void checkUploadStatusByEmptyTask() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(new int[]{}));

        List<Integer> gotTaskIDs = extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat("Неверный перечень taskIDs", gotTaskIDs, hasItems(ArrayUtils.toObject(tasksIDs)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7402")
    public void checkUploadStatusByTaskId() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs[0]));

        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());

        assertThat(gotTaskIDs, contains(tasksIDs[0]));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7403")
    public void checkUploadStatusByTaskIds() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs[0], tasksIDs[2]));

        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());

        assertThat(gotTaskIDs, contains(tasksIDs[0], tasksIDs[2]));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7404")
    public void checkUploadStatusOverLimitTaskArraySize() {
        int[] tasks = new int[ImagesSteps.AD_IMAGE_TASKS_MAX_VALUE+1];
        for (int i = 0; i < tasks.length; i++) {
            tasks[i] = i;
        }

        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .checkUploadStatus(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withAdImageUploadTaskIDS(tasks)
                        ),
                new AxisError(241, AxisErrorDetails.THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
                        "SelectionCriteria.AdImageUploadTaskIDS", ImagesSteps.AD_IMAGE_TASKS_MAX_VALUE)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7405")
    public void checkUploadStatusByNoRightTaskID() {
        AdImageResponse result = api.as(ImageLogins.LOGIN_WITH_NO_IMAGES)
                .userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs[0]));

        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());

        assertThat(gotTaskIDs, empty());

    }
}
