package ru.yandex.autotests.directapi.images.adimage.checkuploadstatus;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.common.api45.AdImageUpload;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.model.images.AdImageMap;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.model.images.AdImageUploadMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;


/**
 * User: mariabye
 * Date: 24.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_CHECK_UPLOAD_STATUS)
public class CheckUploadStatusImagePendingTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void deleteImages(){
        api.as(Logins.SUPER_LOGIN).userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7406")
    public void checkStatusForPendingPicture() {
        int[] taskIDs = api.as(login).userSteps.imagesSteps().putImageInUploadQueue(
                new AdImageURLMap(api.type())
                        .withName("name pending")
                        .withURL(ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR)));

        AdImageUpload image =  api.userSteps.imagesSteps().getAdImageUpload(taskIDs[0]);
        AdImageUploadMap expectedImageState = new AdImageUploadMap(api.type()).withStatus(Status.PENDING);
        BeanCompareStrategy strategy = new BeanCompareStrategy();
        strategy.putFieldMatcher(AdImageMap.AD_IMAGE_HASH, equalTo(null));
        strategy.putFieldMatcher(AdImageMap.AD_IMAGE_URL, equalTo(null));
        assertThat(image, BeanEquals.beanEquals(expectedImageState.getBean()).accordingStrategy(strategy));
    }
}
