package ru.yandex.autotests.directapi.images.adimage.checkuploadstatus;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.common.api45.AdImageUpload;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 24.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_CHECK_UPLOAD_STATUS)
@RunWith(Parameterized.class)
public class CheckUploadStatusInternalRolesTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter()
    public String operator;

    @Parameterized.Parameter(value = 1)
    public Matcher matcher;

    @Parameterized.Parameters(name = "operator = {0}")
    public static Collection roles() {
        tasksIDs = api.as(login).userSteps.imagesSteps().configLoginTasks(login, new int[]{1, 2}, new int[0]);
        Object[][] data = new Object[][]{
                {Logins.SUPER_LOGIN,contains(tasksIDs)},
                {Logins.SUPPORT,contains(tasksIDs)},
                {Logins.PLACER,equalTo(new int[0])},
                {Logins.SUPER_READER, contains(tasksIDs)},
                {Logins.MEDIA, equalTo(new int[0])}
        };
        return Arrays.asList(data);
    }


    private static int[] tasksIDs;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7407")
    public void checkUploadStatusByUndefLogin() {
        api.as(operator).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                .withAction(Action.CHECK_UPLOAD_STATUS)
                .withAdImageSelectionCriteria(
                        new AdImageSelectionCriteriaMap(api.type())
                ),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "SelectionCriteria.Logins")
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7408")
    public void checkUploadStatusByEmptyLogin() {
        api.as(operator).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.CHECK_UPLOAD_STATUS)
                        .withAdImageSelectionCriteria(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withLogins(new String[]{})
                        ),
                new AxisError(30, AxisErrorDetails.THE_ARRAY_CANNOT_BE_EMPTY, "SelectionCriteria.Logins")
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7409")
    public void checkUploadStatusLogin() {
        AdImageResponse result = api.as(ImageLogins.SUPPORT).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withLogins(new String[]{login}).withAdImageUploadTaskIDS(tasksIDs))
                ;

        List<Integer> gotTaskIDs = extract(result.getAdImageUploads(),on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat("Неверный перечень taskIDs", gotTaskIDs, hasItems(ArrayUtils.toObject(tasksIDs)));
    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7410")
    public void checkUploadStatusLogins() {
        AdImageResponse result = api.as(Logins.SUPPORT).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withLogins(login,ImageLogins.LOGIN_WITH_NO_IMAGES));

        List<Integer> gotTaskIDs = extract(result.getAdImageUploads(),on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat("Неверный перечень taskIDs", gotTaskIDs, hasItems(ArrayUtils.toObject(tasksIDs)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7411")
    public void  checkUploadStatusNoDirectLogin() {
        api.as(Logins.SUPPORT).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .checkUploadStatus(new AdImageSelectionCriteriaMap(api.type())
                                .withLogins(ImageLogins.NO_DIRECT_CLIENT)
                                .withAdImageUploadTaskIDS(tasksIDs)),
                new AxisError(251, AxisErrorDetails.NO_ONE_VALID_LOGIN)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7412")
    public void checkUploadStatusOverLimitArraySize() {
        String[] logins = new String[ImagesSteps.AD_IMAGE_GET_LOGIN_MAX_COUNT+1];
        for (int i = 0; i < logins.length; i++) {
            logins[i] = RandomStringUtils.randomAlphabetic(10);
        }


        api.as(Logins.SUPPORT).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .checkUploadStatus(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withLogins(logins)
                        ),
                new AxisError(241, AxisErrorDetails.THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
                        "SelectionCriteria.Logins", ImagesSteps.AD_IMAGE_GET_LOGIN_MAX_COUNT)
        );
    }
}
