package ru.yandex.autotests.directapi.images.adimage.checkuploadstatus;

import org.apache.commons.lang.ArrayUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.common.api45.AdImageUpload;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.empty;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 24.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_CHECK_UPLOAD_STATUS)
public class CheckUploadStatusPagerTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int[] tasksIDs;

    @BeforeClass
    public static void initTest() {
        tasksIDs = api.as(login).userSteps.imagesSteps().configLoginTasks(login, new int[]{1, 2, 3, 4, 5}, new int[0]);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7413")
    public void getHead() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withOffset(0)
                        .withLimit(2)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat(gotTaskIDs, contains(tasksIDs[0], tasksIDs[1]));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7414")
    public void getBody() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withOffset(1)
                        .withLimit(3)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat(gotTaskIDs, contains(tasksIDs[1], tasksIDs[2], tasksIDs[3]));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7423")
    public void getTail() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withOffset(tasksIDs.length - 2)
                        .withLimit(2)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat(gotTaskIDs, contains(tasksIDs[tasksIDs.length - 2], tasksIDs[tasksIDs.length - 1]));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7415")
    public void getOverTail() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withOffset(tasksIDs.length - 2)
                        .withLimit(tasksIDs.length + 10)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat(gotTaskIDs, contains(tasksIDs[tasksIDs.length - 2], tasksIDs[tasksIDs.length - 1]));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7416")
    public void getNextAfterTail() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withOffset(tasksIDs.length)
                        .withLimit(10)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat(gotTaskIDs, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7417")
    public void requestEmptyLimitWithOffset() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withOffset(1)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        int[] expectedTasks = ArrayUtils.remove(tasksIDs.clone(), 0);
        assertThat("Неверное значение поля AdImageUploadTaskID", gotTaskIDs,
                contains(ArrayUtils.toObject(expectedTasks)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7418")
    public void requestNegativeLimit() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.CHECK_UPLOAD_STATUS)
                        .withAdImageSelectionCriteria(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withAdImageUploadTaskIDS(tasksIDs)
                                        .withLimit(-10)
                        ),
                new AxisError(71,
                        AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE, "SelectionCriteria.Limit")
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7419")
    public void requestOverLimit() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.CHECK_UPLOAD_STATUS)
                        .withAdImageSelectionCriteria(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withAdImageUploadTaskIDS(tasksIDs)
                                        .withLimit(ImagesSteps.CHECK_UPLOAD_STATUS_MAX_LIMIT + 1)
                        ),
                new AxisError(71,
                        AxisErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_GREATER_THAN,
                        "SelectionCriteria.Limit", ImagesSteps.CHECK_UPLOAD_STATUS_MAX_LIMIT)
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7420")
    public void requestMaxLimit() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withLimit(ImagesSteps.CHECK_UPLOAD_STATUS_MAX_LIMIT)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        assertThat("Неверное значение поля AdImageUploadTaskID", gotTaskIDs,
                contains(ArrayUtils.toObject(tasksIDs)));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7421")
    public void requestEmptyOffsetWithLimit() {
        AdImageResponse result = api.as(login).userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageUploadTaskIDS(tasksIDs)
                        .withLimit(10)
        );
        List<Integer> gotTaskIDs =
                extract(result.getAdImageUploads(), on(AdImageUpload.class).getAdImageUploadTaskID());
        int[] expectedTasks = ArrayUtils.subarray(tasksIDs, 0, 10);
        assertThat("Неверное значение поля AdImageUploadTaskID", gotTaskIDs,
                contains(ArrayUtils.toObject(expectedTasks)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7422")
    public void requestNegativeOffset() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.CHECK_UPLOAD_STATUS)
                        .withAdImageSelectionCriteria(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withAdImageUploadTaskIDS(tasksIDs)
                                        .withOffset(-10)
                        ),
                new AxisError(71,
                        AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE, "SelectionCriteria.Offset")
        );
    }
}
