package ru.yandex.autotests.directapi.images.adimage.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageMap;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 05.06.15.
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_DELETE)
@Tag(TagDictionary.TRUNK)
public class DeleteImageByInvalidHashTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_FOR_DELETE_TESTS3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7436")
    public void deleteByLoginNotAvailable() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .delete(new AdImageSelectionCriteriaMap<>(api.type())
                                .withLogins(login)),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "SelectionCriteria.AdImageHashes"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7437")
    public void deleteByInvalidHash() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .delete(
                                new AdImageSelectionCriteriaMap<>(api.type())
                                        .withAdImageHashes(RandomStringUtils.randomAlphabetic(22))),
                new AxisError(271, AxisErrorDetails.INVALID, StringUtils.capitalize(AdImageMap.AD_IMAGE_HASH)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7438")
    public void deleteByUndefHash() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .delete(new AdImageSelectionCriteriaMap<>(api.type())),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "SelectionCriteria.AdImageHashes"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7439")
    public void deleteByEmptyHash() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .delete(
                                new AdImageSelectionCriteriaMap<>(api.type())
                                        .withAdImageHashes(new String[]{""})),
                new AxisError(271, AxisErrorDetails.INVALID, StringUtils.capitalize(AdImageMap.AD_IMAGE_HASH)));

    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7440")
    public void deleteByAdHashesOverMaxArraySize() {
        String[] requestHashes = new String[ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE + 1];
        for (int i = 0; i < ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE + 1; i++) {
            requestHashes[i] = RandomStringUtils.randomAlphabetic(22);
        }
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .delete(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withAdImageHashes(requestHashes)),
                new AxisError(241, AxisErrorDetails.THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
                        "SelectionCriteria.AdImageHashes", ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE));
    }

    @Test
    public void deleteByImageAdAdImageHash() {
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1);
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap(api.type())
                        .delete(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withAdImageHashes(adImageHash)),
                new AxisError(271, AxisErrorDetails.INVALID, StringUtils.capitalize(AdImageMap.AD_IMAGE_HASH)));
    }
}
