package ru.yandex.autotests.directapi.images.adimage.get;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.Arrays;
import java.util.List;

import static org.hamcrest.Matchers.contains;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_GET)
@Tag(TagDictionary.TRUNK)
public class GetImagesByAssignedFilterTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_GET_IMAGES_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static AdImage imageAssigned1;
    private static AdImage imageAssigned2;
    private static AdImage imageUnAssigned1;
    private static AdImage imageUnAssigned2;

    private static Long adID1;
    private static Long adID2;

    @BeforeClass
    public static void initTest() {
        String[] clientImages = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2,3,4);

        Long campaignID = api.as(login).userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);

        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, login, 2);
        adID1 = adIDs.get(0);
        adID2 = adIDs.get(1);

        imageAssigned1 = new AdImage();
        imageAssigned1.setAdImageHash(clientImages[0]);
        imageAssigned1.setAssigned(Value.YES);

        imageAssigned2 = new AdImage();
        imageAssigned2.setAdImageHash(clientImages[1]);
        imageAssigned2.setAssigned(Value.YES);

        imageUnAssigned1 = new AdImage();
        imageUnAssigned1.setAdImageHash(clientImages[2]);
        imageUnAssigned1.setAssigned(Value.NO);

        imageUnAssigned2 = new AdImage();
        imageUnAssigned2.setAdImageHash(clientImages[3]);
        imageUnAssigned2.setAssigned(Value.NO);


        api.userSteps.imagesSteps().assignImageToBannerIfNot(adID1, imageAssigned1.getAdImageHash());
        api.userSteps.imagesSteps().assignImageToBannerIfNot(adID2, imageAssigned2.getAdImageHash());

    }

    @AfterClass
    public static void clearTest() {
        api.userSteps.imagesSteps().setAdImageAssociation(adID1, null);
        api.userSteps.imagesSteps().setAdImageAssociation(adID2, null);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7441")
    public void getAssignedImages() {
        log.info("Запрос картинок с Assigned = Yes");
        AdImageResponse imageResponse =
                api.userSteps.imagesSteps().adImageGet(
                        new AdImageSelectionCriteriaMap(api.type())
                                .withAssigned(Value.YES));

        assertThat("Неверный список картинок в ответе", Arrays.asList(imageResponse.getAdImages()),
                contains(BeanEquals.beanEquals(imageAssigned1), BeanEquals.beanEquals(imageAssigned2)));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7442")
    public void getUnAssignedImages() {
        log.info("Запрос картинок с Assigned = No");
        AdImageResponse imageResponse =
                api.userSteps.imagesSteps().adImageGet(
                        new AdImageSelectionCriteriaMap(api.type())
                                .withAssigned(Value.NO));

        assertThat("Неверный список картинок в ответе", Arrays.asList(imageResponse.getAdImages()),
                contains(BeanEquals.beanEquals(imageUnAssigned1), BeanEquals.beanEquals(imageUnAssigned2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7443")
    public void getAllTypeOfImages() {
        log.info("Запрос картинок с Assigned = {Yes,No}");
        AdImageResponse imageResponse =
                api.userSteps.imagesSteps().adImageGet(
                        new AdImageSelectionCriteriaMap(api.type())
                                .withAssigned(Value.NO, Value.YES));

        assertThat("Неверный список картинок в ответе",
                Arrays.asList(imageResponse.getAdImages()),
                contains(
                        BeanEquals.beanEquals(imageAssigned1),
                        BeanEquals.beanEquals(imageAssigned2),
                        BeanEquals.beanEquals(imageUnAssigned1),
                        BeanEquals.beanEquals(imageUnAssigned2)
                        ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7444")
    public void getEmptyAssignedArray() {
        log.info("Запрос картинок с Assigned = {}");
        AdImageResponse imageResponse =
                api.userSteps.imagesSteps().adImageGet(
                        new AdImageSelectionCriteriaMap(api.type())
                                .withAssigned());

        assertThat("Неверный список картинок в ответе",
                Arrays.asList(imageResponse.getAdImages()),
                contains(
                        BeanEquals.beanEquals(imageAssigned1),
                        BeanEquals.beanEquals(imageAssigned2),
                        BeanEquals.beanEquals(imageUnAssigned1),
                        BeanEquals.beanEquals(imageUnAssigned2)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7445")
    public void getInvalidAssignedArray() {
        log.info("Запрос картинок с Assigned = {\"y\"}");
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .getImage(
                                new AdImageSelectionCriteriaMap<>(api.type())
                                        .withAssigned("y")),
                        new AxisError(71, AxisErrorDetails.ARRAY_SHOULD_CONTAIN_VALUES,
                                "SelectionCriteria.Assigned", "Yes or No")
                );
    }
}
