package ru.yandex.autotests.directapi.images.adimage.get;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageMap;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.List;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;


/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_GET)
@Tag(TagDictionary.TRUNK)
public class GetImagesByHashTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_GET_IMAGES_2;
    private static String anotherLogin = ImageLogins.LOGIN_GET_IMAGES_3;


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String[] clientImages;
    private static String noRight;
    private static DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);

    @BeforeClass
    public static void initTest() {
        String[] hashes_another = api.as(anotherLogin).userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 3);
        clientImages = api.as(login).userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2);
        noRight = hashes_another[1];
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7446")
    public void getImageByHash() {
        AdImage image = api.userSteps.imagesSteps().getAdImage(clientImages[0]);
        assertThat("Неверное значение поля AdImageHash",
                image.getAdImageHash(), equalTo(clientImages[0]));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7447")
    public void getImageByHashValidateUrl() {
        AdImage image = api.userSteps.imagesSteps().getAdImage(clientImages[0]);
        BannerImagesFormatsRecord bannerImagesFormatsRecord = directJooqDbSteps.imagesSteps().getBannerImagesFormatsRecords(image.getAdImageHash());

        assertThat("Неверное значение поля AdImageURL", image.getAdImageURL(),
                equalTo(api.userSteps.imagesSteps().getDirectAdImageHref(image.getAdImageHash(), bannerImagesFormatsRecord.getMdsGroupId(), bannerImagesFormatsRecord.getNamespace().toString())));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7448")
    public void getImagesByHash() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageHashes(clientImages)
        );

        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);

        assertThat("Получен неверный список картинок", hashes, hasItems(clientImages));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7449")
    public void getImagesByUndefHash() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
        );

        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);

        assertThat("Получен неверный список картинок", hashes, hasItems(clientImages));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7450")
    public void getImagesByEmptyHashArray() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageHashes(new String[]{})
        );

        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);

        assertThat("Получен неверный список картинок", hashes, hasItems(clientImages));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7451")
    public void getImagesByNoRight() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageHashes(new String[]{noRight})
        );

        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Неверное значение поля AdImageHash", hashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7452")
    public void getImagesByEmptyHash() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageHashes(new String[]{""})
        );

        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Неверное значение поля AdImageHash", hashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7453")
    public void getImagesByNotExistingHash() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageHashes(new String[]{"1"})
        );

        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Неверное значение поля AdImageHash", hashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7454")
    public void getImagesByMaxArrayLengthHash() {
        String[] requestHashes = new String[ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE];
        requestHashes[0] = clientImages[0];
        for (int i = 1; i < ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE; i++) {
            requestHashes[i] = RandomStringUtils.randomAlphabetic(requestHashes[0].length());
        }
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageHashes(requestHashes)
        );

        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Неверное значение поля AdImageHash", hashes, equalTo(Arrays.asList(clientImages[0])));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7455")
    public void getImagesByOverMaxArrayLengthHash() {
        String[] requestHashes = new String[ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE + 1];
        requestHashes[0] = clientImages[0];
        for (int i = 1; i < ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE + 1; i++) {
            requestHashes[i] = RandomStringUtils.randomNumeric(requestHashes[0].length());
        }
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.GET)
                        .withAdImageSelectionCriteria(
                                new AdImageSelectionCriteriaMap(api.type())
                                        .withAdImageHashes(requestHashes)
                        ),
                new AxisError(241, AxisErrorDetails.THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
                        "SelectionCriteria.AdImageHashes", ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE)
        );
    }

    @Test
    public void getImagesByImageAdAdImageHash() {
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1);
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withAdImageHashes(adImageHash)
        );
        List<String> hashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Неверное значение поля AdImageHash", hashes, empty());
    }
}
