package ru.yandex.autotests.directapi.images.adimage.get;

import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasItems;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_GET)
@Tag(TagDictionary.TRUNK)
public class GetImagesByLoginTest {

    private static String CLIENT = ImageLogins.LOGIN_GET_IMAGES_4;
    private static String CLIENT_WITHOUT_IMAGE = ImageLogins.LOGIN_WITH_NO_IMAGES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private String[] clientImageHashes;

    @Before
    public void getClientImages() {
        clientImageHashes = api.as(CLIENT).userSteps.imagesSteps().configLoginImages(CLIENT, ImageType.REGULAR, 1, 2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7456")
    public void getImagesByUndefLogin() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withLogins(CLIENT));

        List<String> gotHashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Картинки не совпали с ожидаемыми",
                gotHashes, hasItems(clientImageHashes));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7457")
    public void getImagesByEmptyLoginArray() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withLogins());

        List<String> gotHashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Картинки не совпали с ожидаемыми",
                gotHashes, hasItems(clientImageHashes));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7458")
    public void getImagesByDotLoginArray() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withLogins(CLIENT.replaceAll("-", ".")));

        List<String> gotHashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Картинки не совпали с ожидаемыми",
                gotHashes, hasItems(clientImageHashes));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7459")
    public void getImagesByWrongLoginArraySkipped() {
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                new AdImageSelectionCriteriaMap(api.type())
                        .withLogins(ImageLogins.CLIENT_SELF));

        List<String> gotHashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Картинки не совпали с ожидаемыми",
                gotHashes, hasItems(clientImageHashes));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7460")
    public void getImagesByLoginWithNoImages() {
        api.as(CLIENT_WITHOUT_IMAGE).userSteps.imagesSteps().adImageDeleteForLogin(CLIENT_WITHOUT_IMAGE);
        AdImageResponse imageResponse = api.userSteps.imagesSteps().adImageGet(
                        new AdImageSelectionCriteriaMap(api.type())
                                .withLogins(CLIENT_WITHOUT_IMAGE));

        List<String> gotHashes = extractProperty(imageResponse.getAdImages(), AdImageMap.AD_IMAGE_HASH);
        assertThat("Картинки не совпали с ожидаемыми",
                gotHashes, empty());
    }

}

