package ru.yandex.autotests.directapi.images.adimage.getlimits;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.qatools.allure.annotations.Features;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_GET_LIMITS)
public class GetLimitByAgencyRequestTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login;
    private static String agencyLogin = ImageLogins.AGENCY_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void createSubClient() {
        User user = api.userSteps.addAgencySubClient(agencyLogin,"at-image-limit", Currency.RUB);
        login = user.getLogin();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7480")
    public void getLimitByNoRightLogin() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .getLimits(new AdImageSelectionCriteriaMap<>(api.type())
                                .withLogins(ImageLogins.CLIENT_SELF)),
                new AxisError(54)
        );
    }
}
