package ru.yandex.autotests.directapi.images.adimage.getlimits;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.common.api45.AdImageLimit;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.contains;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_GET_LIMITS)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetLimitByClientRequestTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_WITH_NO_IMAGES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter
    public String[] requestedLogins;

    @Parameterized.Parameter(value = 1)
    public String title;

    @Parameterized.Parameters(name = "requested logins = {1}")
    public static Collection roleValues() {
        Object[][] data = new Object[][]{
                {null, "null"},
                {new String[]{login}, "{\""+login+"\"}"},
                {new String[]{""},"{\"\"}"},
                {new String[]{null},"{null}"},
                {new String[]{Logins.PLACER},"{\""+Logins.PLACER+"\"}"},
                {new String[]{Logins.SUPER_READER, login},"{\""+Logins.SUPER_READER+"\", \""+login+"\"}"}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void deleteImages() {
        api.as(Logins.SUPER_LOGIN).userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7481")
    public void getLimitByClientWithNoImages() {
        AdImageResponse response = api.as(login).userSteps.imagesSteps()
                .adImageGetLimits(
                        new AdImageSelectionCriteriaMap(api.type())
                                .withLogins(requestedLogins));

        AdImageLimit defaultLimit = new AdImageLimit();
        defaultLimit.setLogin(ClientInfoMap.normilizeLogin(login));
        defaultLimit.setUtilized(0);
        defaultLimit.setCapacity(1000);
        assertThat("Неверные значения лимитов", Arrays.asList(response.getAdImageLimits()),
                contains(BeanEquals.beanEquals(defaultLimit)));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7482")
    public void getLimitsLimitAndOffsetIgnored() {
        AdImageResponse response = api.as(login).userSteps.imagesSteps()
                .adImageGetLimits(
                        new AdImageSelectionCriteriaMap(api.type())
                                .withLimit(0).withOffset(1));

        AdImageLimit defaultLimit = new AdImageLimit();
        defaultLimit.setLogin(ClientInfoMap.normilizeLogin(login));
        defaultLimit.setUtilized(0);
        defaultLimit.setCapacity(1000);
        assertThat("Неверные значения лимитов", Arrays.asList(response.getAdImageLimits()),
                contains(BeanEquals.beanEquals(defaultLimit)));
    }
}
