package ru.yandex.autotests.directapi.images.adimage.getlimits;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.common.api45.AdImageLimit;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_GET_LIMITS)
public class GetLimitsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_FOR_GET_LIMITS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().setImagePoolLimit(login, 3);
    }

    static AdImageLimit expectedLimit;

    @Before
    public void deleteImages() {
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);

        expectedLimit = new AdImageLimit();
        expectedLimit.setLogin(ClientInfoMap.normilizeLogin(login));
        expectedLimit.setCapacity(3);
        expectedLimit.setUtilized(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7489")
    public void uploadRawImageChangeUtilized() {
        api.as(login).userSteps.imagesSteps().uploadRawImage(ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR));
        AdImageLimit limit = api.userSteps.imagesSteps().getLimit(null);

        expectedLimit.setUtilized(1);
        assertThat("Неверные значения лимитов", limit, BeanEquals.beanEquals(expectedLimit));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7490")
    public void uploadRawImageBySupportChangeUtilized() {
        api.as(ImageLogins.SUPPORT).userSteps.imagesSteps().adImageUploadRawData(
                RandomStringUtils.randomAlphabetic(5),ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR),login);
        AdImageLimit limit = api.as(login).userSteps.imagesSteps().getLimit(null);

        expectedLimit.setUtilized(1);
        assertThat("Неверные значения лимитов", limit, BeanEquals.beanEquals(expectedLimit));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7491")
    public void deleteRawImageChangeUtilized() {
        AdImage image = api.as(login).userSteps.imagesSteps().uploadRawImage(ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR));
        api.userSteps.imagesSteps().adImageDelete(image.getAdImageHash());

        AdImageLimit limit = api.userSteps.imagesSteps().getLimit(null);

        expectedLimit.setUtilized(0);
        assertThat("Неверные значения лимитов", limit, BeanEquals.beanEquals(expectedLimit));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7492")
    public void deleteNotAllRawImageChangeUtilized() {
        api.as(login).userSteps.imagesSteps().uploadRawImage(ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR));
        AdImage image = api.as(login).userSteps.imagesSteps().uploadRawImage(ImagesSteps.getDefaultImageUrl(2, ImageType.REGULAR));
        api.userSteps.imagesSteps().adImageDelete(image.getAdImageHash());

        AdImageLimit limit = api.userSteps.imagesSteps().getLimit(null);

        expectedLimit.setUtilized(1);
        assertThat("Неверные значения лимитов", limit, BeanEquals.beanEquals(expectedLimit));
    }

    // при наличии активных объявлений длина пула картинок пропорционально увеличивается
    // available_queue_size = default_queue_size + 2*all_banners_count_except_archived
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7493")
    public void poolSizeIfActiveBanner(){
        api.as(login).userSteps.addActiveCampaign(login, 1);

        AdImageLimit limit = api.userSteps.imagesSteps().getLimit(null);


        expectedLimit.setUtilized(0);
        expectedLimit.setCapacity(5);
        assertThat("Неверные значения лимитов", limit, BeanEquals.beanEquals(expectedLimit));
    }

    // при наличии активных объявлений длина пула картинок пропорционально увеличивается
    // available_queue_size = default_queue_size + 2*all_banners_count_except_archived
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7494")
    public void poolSizeWithActiveAndArchivedCampaignTest(){
        //https://jira.yandex-team.ru/browse/DIRECT-32989
        api.as(login).userSteps.addActiveCampaign(login, 1);

        Long campaignId = api.as(login).userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, login);
        api.as(login).userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        api.as(login).userSteps.campaignStepsV5().campaignsSuspend(campaignId);

        AdImageLimit limit = api.userSteps.imagesSteps().getLimit(null);

        expectedLimit.setUtilized(0);
        expectedLimit.setCapacity(7);
        assertThat("Неверные значения лимитов", limit, BeanEquals.beanEquals(expectedLimit));
    }
}
