package ru.yandex.autotests.directapi.images.adimage.upload;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.common.api45.AdImageUpload;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.collect;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_UPLOAD)
public class LoginForClientTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_UPLOAD_3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void deleteImages(){
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7515")
    public void uploadImageUndefLogin() {
        AdImageResponse uploadResponse = api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withLogin(null)
                        .withName(RandomStringUtils.randomAlphabetic(5))
                        .withURL(ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR))
        );
        AdImageUpload[] uploads = api.userSteps.imagesSteps().getAdImageUploads(
                new AdImageSelectionCriteriaMap(api.type()).withAdImageUploadTaskIDS(
                        ImagesSteps.extractAdImageUploadTaskIDS(uploadResponse.getActionsResult())
                ));
        List<String> logins = collect(uploads, on(AdImageUpload.class).getLogin());
        assertThat("Неверный владелец картинки", logins, contains(login));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7514")
    public void uploadImageEmptyLogin() {
        AdImageResponse uploadResponse = api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withLogin("")
                        .withName(RandomStringUtils.randomAlphabetic(5))
                        .withURL(ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR))
        );
        AdImageUpload[] uploads = api.userSteps.imagesSteps().getAdImageUploads(
                new AdImageSelectionCriteriaMap(api.type()).withAdImageUploadTaskIDS(
                        ImagesSteps.extractAdImageUploadTaskIDS(uploadResponse.getActionsResult())
                ));
        List<String> logins = collect(uploads, on(AdImageUpload.class).getLogin());
        assertThat("Неверный владелец картинки", logins, contains(login));

    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7516")
    public void uploadImageClientLogin() {
        AdImageResponse uploadResponse = api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withLogin(login)
                        .withName(RandomStringUtils.randomAlphabetic(5))
                        .withURL(ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR))
        );
        AdImageUpload[] uploads = api.userSteps.imagesSteps().getAdImageUploads(
                new AdImageSelectionCriteriaMap(api.type()).withAdImageUploadTaskIDS(
                        ImagesSteps.extractAdImageUploadTaskIDS(uploadResponse.getActionsResult())
                ));
        List<String> logins = collect(uploads, on(AdImageUpload.class).getLogin());
        assertThat("Неверный владелец картинки", logins, contains(login));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7517")
    public void uploadImageNoRightLogin() {
        AdImageResponse uploadResponse = api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withLogin(ImageLogins.CLIENT_SELF)
                        .withName(RandomStringUtils.randomAlphabetic(5))
                        .withURL(ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR))
        );
        AdImageUpload[] uploads = api.userSteps.imagesSteps().getAdImageUploads(
                new AdImageSelectionCriteriaMap(api.type()).withAdImageUploadTaskIDS(
                        ImagesSteps.extractAdImageUploadTaskIDS(uploadResponse.getActionsResult())
                ));
        List<String> logins = collect(uploads, on(AdImageUpload.class).getLogin());
        assertThat("Неверный владелец картинки", logins, contains(login));
    }
}
