package ru.yandex.autotests.directapi.images.adimage.uploadrawdata;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.collect;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_UPLOAD_RAW_DATA)
@Tag(TagDictionary.TRUNK)
public class ImageNameTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_UPLOADRAW_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void deleteImages(){
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7518")
    public void uploadImageWithValidName() {
        String name = RandomStringUtils.randomAlphabetic(5) + ".jpg";
        AdImageResponse uploadResponse = api.userSteps.imagesSteps().adImageUploadRawData(
                name,
                ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR),
                login
        );
        AdImage[] images = api.userSteps.imagesSteps().getAdImages(
                new AdImageSelectionCriteriaMap(api.type()).withAdImageHashes(
                        ImagesSteps.extractAdImageHashesProperty(uploadResponse.getActionsResult())
                ));
        List<String> names = collect(images, on(AdImage.class).getName());
        assertThat("Неверное название картинки", names, contains(name));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7522")
    public void uploadImagesWithExistName() {
        String name = RandomStringUtils.randomAlphabetic(5) + ".jpg";
        AdImageResponse uploadResponse1 = api.userSteps.imagesSteps().adImageUploadRawData(
                name,
                ImagesSteps.getDefaultImageUrl(2, ImageType.REGULAR),
                login
        );
        String[] hashes1 = ImagesSteps.extractAdImageHashesProperty(uploadResponse1.getActionsResult());
        AdImageResponse uploadResponse2 = api.userSteps.imagesSteps().adImageUploadRawData(
                name,
                ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR),
                login
        );
        String[] hashes2 = ImagesSteps.extractAdImageHashesProperty(uploadResponse2.getActionsResult());

        AdImage[] images = api.userSteps.imagesSteps().getAdImages(
                new AdImageSelectionCriteriaMap(api.type()).withAdImageHashes(
                        (String[]) ArrayUtils.addAll(hashes1, hashes2)

                ));
        List<String> names = collect(images, on(AdImage.class).getName());
        assertThat("Неверное название картинки", names, contains(name,name));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7519")
    public void uploadImageWithUndefName() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                null,
                ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR),
                login
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "AdImageRawData[0].Name")
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7520")
    public void uploadImageWithEmptyName() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                "",
                ImagesSteps.getDefaultImageUrl(5, ImageType.REGULAR),
                login
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY, "AdImageRawData[0].Name")
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7521")
    public void uploadImageWithSpacesName() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                "   ",
                ImagesSteps.getDefaultImageUrl(6, ImageType.REGULAR),
                login
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY, "AdImageRawData[0].Name")
        );

    }
}
