package ru.yandex.autotests.directapi.images.adimage.uploadrawdata;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.images.AdImageRawMap;
import ru.yandex.autotests.directapi.model.images.AdImageRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_UPLOAD_RAW_DATA)
@Tag(TagDictionary.TRUNK)
public class LoginForAgencylRolesTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String agencyLogin = ImageLogins.AGENCY_YE_DEFAULT;
    private static String clientLogin;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void createSubClient(){
        User user = api.userSteps.addAgencySubClient(agencyLogin,"at-image-uploadraw", Currency.RUB);
        clientLogin = user.getLogin();
    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7524")
    public void uploadImageUndefLogin() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.UPLOAD_RAW_DATA)
                        .withAdImageRawData(new AdImageRawMap(api.type())
                                .withLogin(null)
                                .withName(RandomStringUtils.randomAlphabetic(5))
                                .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR)))),
                new AxisError(251, AxisErrorDetails.NO_ONE_VALID_LOGIN));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7523")
    public void uploadImageEmptyLogin() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.UPLOAD_RAW_DATA)
                        .withAdImageRawData(new AdImageRawMap(api.type())
                                .withLogin("")
                                .withName(RandomStringUtils.randomAlphabetic(5))
                                .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR)))),
                new AxisError(251, AxisErrorDetails.NO_ONE_VALID_LOGIN));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7525")
    public void uploadImageNoDirectLogin() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE,
                new AdImageRequestMap<>(api.type())
                        .withAction(Action.UPLOAD_RAW_DATA)
                        .withAdImageRawData(new AdImageRawMap(api.type())
                                .withLogin(ImageLogins.NO_DIRECT_CLIENT)
                                .withName(RandomStringUtils.randomAlphabetic(5))
                                .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR)))),
                new AxisError(251, AxisErrorDetails.NO_ONE_VALID_LOGIN));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7526")
    public void uploadImageClientLogin() {
        AdImage uploadedImage = api.userSteps.imagesSteps().uploadRawImage(RandomStringUtils.randomAlphabetic(5),
                ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR), clientLogin);
        assertThat("Неверный владелец картинки", uploadedImage.getLogin(),
                equalTo(ClientInfoMap.normilizeLogin(clientLogin)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7527")
    public void uploadImageNoRightLogin() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                new AdImageRawMap(api.type())
                        .withLogin(ImageLogins.CLIENT_SELF)
                        .withName(RandomStringUtils.randomAlphabetic(5))
                        .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR)))
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(54, AxisErrorDetails.NO_RIGTHS_FOR_CLIENT)
        );
    }
}
