package ru.yandex.autotests.directapi.images.adimage.uploadrawdata;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_UPLOAD_RAW_DATA)
@Tag(TagDictionary.TRUNK)
public class LoginForClientTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_UPLOADRAW_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void deleteImages(){
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7531")
    public void uploadRawImageUndefLogin() {
        AdImage uploadedImage = api.userSteps.imagesSteps().uploadRawImage(RandomStringUtils.randomAlphabetic(5),
                ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR));
        assertThat("Неверный владелец картинки", uploadedImage.getLogin(),
                equalTo(ClientInfoMap.normilizeLogin(login)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7528")
    public void uploadImageEmptyLogin() {
        AdImage uploadedImage = api.userSteps.imagesSteps().uploadRawImage(RandomStringUtils.randomAlphabetic(5),
                ImagesSteps.getDefaultImageUrl(2, ImageType.REGULAR), "");
        assertThat("Неверный владелец картинки", uploadedImage.getLogin(),
                equalTo(ClientInfoMap.normilizeLogin(login)));

    }
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7529")
    public void uploadImageClientLogin() {
        AdImage uploadedImage = api.userSteps.imagesSteps().uploadRawImage(RandomStringUtils.randomAlphabetic(5),
                ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR), login);
        assertThat("Неверный владелец картинки", uploadedImage.getLogin(),
                equalTo(ClientInfoMap.normilizeLogin(login)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7530")
    public void uploadImageNoRightLogin() {
        AdImage uploadedImage = api.userSteps.imagesSteps().uploadRawImage(RandomStringUtils.randomAlphabetic(5),
                ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR), ImageLogins.CLIENT_FREE_YE_DEFAULT);
        assertThat("Неверный владелец картинки", uploadedImage.getLogin(),
                equalTo(ClientInfoMap.normilizeLogin(login)));
    }
}
