package ru.yandex.autotests.directapi.images.adimage.uploadrawdata;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageRawMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 01.03.16.
 */
@Aqua.Test
@Features(ImagesFeatures.NOT_REGRESSION_YET)
@Description("Тест не регрессионный т.к. из-за большой картинки получаем OutOfMemoryError: Java heap space")
public class UpdateBigImageRawTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_UPLOADRAW_3;
    public String urlOfBigImage = "https://direct-qa.s3.mds.yandex.net/images/5000x5000maxsize.jpg";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String name = RandomStringUtils.randomAlphabetic(5);

    @BeforeClass
    public static void deleteImages() {
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8883")
    public void uploadImageWithTooBigRawData() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                new AdImageRawMap(api.type())
                        .withName(name)
                        .withRawData(ImageBase64Utils.getBase64EncodedFileData(urlOfBigImage))
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(71, AxisErrorDetails.LENGTH_OF_BASE64_FIELD_SHOULD_NOT_EXCEED,
                        "AdImageRawData[0].RawData", ImagesSteps.IMAGE_RAW_DATA_LIMIT)
        );
    }
}
