package ru.yandex.autotests.directapi.images.adimage.uploadrawdata;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageRawMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by ginger on 14.01.16.
 * https://st.yandex-team.ru/TESTIRT-8018
 */
@Aqua.Test
@Feature(ImagesFeatures.AD_IMAGE_UPLOAD_RAW_DATA)
@Issue("https://st.yandex-team.ru/DIRECT-49536")
@Description("проверка корректой работы валидации при попытке загрузить невалидные картинки больших размеров")
@RunWith(Parameterized.class)
public class UploadInValidBigImageRawTest {

    private static String login = ImageLogins.LOGIN_UPLOADRAW_6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter()
    public String imageName;

    @Parameterized.Parameter(value = 1)
    public String imageUrl;

    @Parameterized.Parameter(value = 2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {ImagesSteps.nameInvalidBigImages.get(1),
                        ImagesSteps.getInvalidImageUrl(1, ImageType.WIDE),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidBigImages.get(2),
                        ImagesSteps.getInvalidImageUrl(2, ImageType.WIDE),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidBigImages.get(3),
                        ImagesSteps.getInvalidImageUrl(3, ImageType.REGULAR),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidBigImages.get(4),
                        ImagesSteps.getInvalidImageUrl(4, ImageType.REGULAR),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidBigImages.get(5),
                        ImagesSteps.getInvalidImageUrl(5, ImageType.REGULAR),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidBigImages.get(6),
                        ImagesSteps.getInvalidImageUrl(6, ImageType.REGULAR),
                        new AxisError(272, AxisErrorDetails.INVALID_FILE_TYPE)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void deleteImages(){
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7538")
    public void uploadRawImage() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                new AdImageRawMap(api.type())
                        .withName(imageName)
                        .withRawData(ImageBase64Utils.getBase64EncodedFileData(imageUrl))
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                expectedError
        );
    }


}
