package ru.yandex.autotests.directapi.images.adimage.uploadrawdata;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.images.AdImageRawMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * User: mariabye
 * Date: 23.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_UPLOAD_RAW_DATA)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UploadInValidImageSizeRawTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_UPLOADRAW_4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter()
    public String imageName;

    @Parameterized.Parameter(value = 1)
    public String imageUrl;

    @Parameterized.Parameter(value = 2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {ImagesSteps.nameInvalidSmallImages.get(1),
                        ImagesSteps.getInvalidImageUrl(1, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(2),
                        ImagesSteps.getInvalidImageUrl(2, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(3),
                        ImagesSteps.getInvalidImageUrl(3, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(4),
                        ImagesSteps.getInvalidImageUrl(4, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(5),
                        ImagesSteps.getInvalidImageUrl(5, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(6),
                        ImagesSteps.getInvalidImageUrl(6, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.INVALID_FILE_TYPE)},
                {ImagesSteps.nameInvalidSmallImages.get(7),
                        ImagesSteps.getInvalidImageUrl(7, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(8),
                        ImagesSteps.getInvalidImageUrl(8, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(9),
                        ImagesSteps.getInvalidImageUrl(9, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(10),
                        ImagesSteps.getInvalidImageUrl(10, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ImagesSteps.nameInvalidSmallImages.get(11),
                        ImagesSteps.getInvalidImageUrl(11, ImageType.SMALL),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(1).getName(),
                        ValidImageData.getValidImageAdImage(1).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(2).getName(),
                        ValidImageData.getValidImageAdImage(2).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(4).getName(),
                        ValidImageData.getValidImageAdImage(4).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(7).getName(),
                        ValidImageData.getValidImageAdImage(7).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(8).getName(),
                        ValidImageData.getValidImageAdImage(8).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(9).getName(),
                        ValidImageData.getValidImageAdImage(9).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(10).getName(),
                        ValidImageData.getValidImageAdImage(10).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(11).getName(),
                        ValidImageData.getValidImageAdImage(11).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(12).getName(),
                        ValidImageData.getValidImageAdImage(12).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(13).getName(),
                        ValidImageData.getValidImageAdImage(13).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)},
                {ValidImageData.getValidImageAdImage(14).getName(),
                        ValidImageData.getValidImageAdImage(14).getUrl(),
                        new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void deleteImages() {
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7538")
    public void uploadRawImage() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUploadRawData(
                new AdImageRawMap(api.type())
                        .withName(imageName)
                        .withRawData(new String(ImageBase64Utils.getBase64EncodedFileData(imageUrl)))
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                expectedError
        );
    }

}
