package ru.yandex.autotests.directapi.images.adimage.uploadrawdata;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by ginger on 14.01.16.
 * https://st.yandex-team.ru/TESTIRT-8018
 */
@Aqua.Test
@Feature(ImagesFeatures.AD_IMAGE_UPLOAD_RAW_DATA)
@Description("проверка корректной загрузки картинок больших размеров")
@Issue("https://st.yandex-team.ru/DIRECT-49536")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UploadValidBigImageRawTest {

    private static String login = ImageLogins.LOGIN_UPLOADRAW_7;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter()
    public String imageName;

    @Parameterized.Parameter(value = 1)
    public String imageUrl;

    @Parameterized.Parameters(name = "{0}")
    public static Collection roles() {
        Object[][] data = new Object[ImagesSteps.nameValidRegularImages.size() + ImagesSteps.nameValidWideImages.size()][];
        for (int i = 0; i < ImagesSteps.nameValidRegularImages.size() + ImagesSteps.nameValidWideImages.size(); i++) {
            if (i < ImagesSteps.nameValidRegularImages.size()) {
                data[i] = new Object[]{ImagesSteps.nameValidRegularImages.get(i + 1),
                        ImagesSteps.getDefaultImageUrl(i + 1, ImageType.REGULAR)};
            } else {
                data[i] = new Object[]{ImagesSteps.nameValidWideImages.get(i + 1 - ImagesSteps.nameValidRegularImages.size()),
                        ImagesSteps.getDefaultImageUrl(i + 1 - ImagesSteps.nameValidRegularImages.size(), ImageType.WIDE)};
            }
        }
        return Arrays.asList(data);
    }

    private static DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);

    @BeforeClass
    public static void deleteImages(){
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8885")
    public void uploadRawImage() {
        AdImage adImage = api.userSteps.imagesSteps().uploadRawImage(
                imageName,
                imageUrl,
                login
        );
        BannerImagesFormatsRecord bannerImagesFormatsRecord = directJooqDbSteps.imagesSteps().getBannerImagesFormatsRecords(adImage.getAdImageHash());
        String expectedUrl = api.userSteps.imagesSteps().getDirectAdImageHref(adImage.getAdImageHash(), bannerImagesFormatsRecord.getMdsGroupId(), bannerImagesFormatsRecord.getNamespace().toString());
        assertThat("Неверная ссылка на картинку в Директ", adImage.getAdImageURL(), equalTo(expectedUrl));
    }

}
