package ru.yandex.autotests.directapi.images.association.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.hasItems;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@Tag(TagDictionary.TRUNK)
public class ClientGetAssociationsByLoginTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_1;

    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String assignedHash1;
    private static String assignedHash2;

    @BeforeClass
    public static void initTest() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2);
        assignedHash1 = hashes[0];
        assignedHash2 = hashes[1];

        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, 2);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(0), assignedHash1);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(1), assignedHash2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7540")
    public void getByNullLoginArray() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7541")
    public void getByEmptyArray() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withLogins()
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7542")
    public void getByLogin() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withLogins(login)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7543")
    public void getByNoRightLogin() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withLogins(ImageLogins.CLIENT_SELF)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }
}
