package ru.yandex.autotests.directapi.images.association.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@Tag(TagDictionary.TRUNK)
public class GetAssociationsByAdIDsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String assignedHash1;
    private static String assignedHash2;
    private static Long campaignID;
    private static Long adID1;
    private static Long adID2;

    @BeforeClass
    public static void initTest() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2);
        assignedHash1 = hashes[0];
        assignedHash2 = hashes[1];
        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, login, 2);
        adID1 = adIDs.get(0);
        adID2 = adIDs.get(1);
        api.userSteps.imagesSteps().setAdImageAssociation(adID1, assignedHash1);
        api.userSteps.imagesSteps().setAdImageAssociation(adID2, assignedHash2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7544")
    public void getByEmptyArray() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdIDS()
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7545")
    public void getByAdID() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdIDS(adID1)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7546")
    public void getByAdIDsWithImage() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdIDS(adID1, adID2)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7547")
    public void getByAdIDsWithImageAndNot() {
        Long adGroupID = api.as(login).userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        Long adID = api.as(login).userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdIDS(adID, adID2)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7548")
    public void getByNegativeAdID() {
        api.as(login).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withCampaignIDS(campaignID.intValue())
                                        .withAdIDS(-adID2)
                        ),
                new AxisError(71, AxisErrorDetails.ARRAY_SHOULD_CONTAIN_UNSIGNED_INTEGER_VALUE,
                        "SelectionCriteria.AdIDS")
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7549")
    public void getByDeletedAdID() {
        Long adGroupID = api.as(login).userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        Long adID = api.as(login).userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        api.userSteps.adsSteps().adsDelete(login, adID);

        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdIDS(adID)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7550")
    public void getByNoRightAdID() {
        api.as(ImageLogins.CLIENT_SELF).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withCampaignIDS(campaignID.intValue())
                                        .withAdIDS(adID2)
                        ),
                new AxisError(54)
        );
    }
}
