package ru.yandex.autotests.directapi.images.association.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@Tag(TagDictionary.TRUNK)
public class GetAssociationsByAdImageHashesTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_3;
    static String login_other = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String assignedHash1;
    private static String assignedHash2;
    private static String unassignedHash;
    private static Long campaignID;

    @BeforeClass
    public static void initTest() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2, 3);
        assignedHash1 = hashes[0];
        assignedHash2 = hashes[1];
        unassignedHash = hashes[2];
        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, login, 2);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(0), assignedHash1);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(1), assignedHash2);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7551")
    public void getByEmptyArray() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdImageHashes()
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7552")
    public void getByAdImageHash() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdImageHashes(assignedHash1)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7553")
    public void getByAdImageHashes() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdImageHashes(assignedHash1, assignedHash2)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7554")
    public void getByUnAssignedAdImageHashes() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdImageHashes(unassignedHash)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7555")
    public void getByInvalidAdImageHash() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdImageHashes(assignedHash2 + "1")
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7556")
    public void getByEmptyAdImageHash() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdImageHashes("")
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7557")
    public void getByNoRightAdImageHash() {
        String[] hashes = api.as(login_other).userSteps.imagesSteps().configLoginImages(login_other, ImageType.REGULAR, 4);


        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withAdImageHashes(hashes[0])
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }
}
