package ru.yandex.autotests.directapi.images.association.get;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersHidden;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.ShortClientInfo;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 24.12.14.
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@RunWith(Parameterized.class)
public class GetAssociationsByLoginNegativeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long campaignID;

    @Parameterized.Parameters(name = "Login: {0}")
    public static Collection roleValues() {
        List<ShortClientInfo> clients = api.as(Logins.MANAGER_DEFAULT).userSteps.clientSteps()
                .getSubClientsNotArch(Logins.MANAGER_DEFAULT);
        String managerClientLogin = clients.get(5).getLogin();
        String managerClientLoginAnother = clients.get(6).getLogin();

        // NB: пометим пользователя как тестового, чтоб бы для него не блокировался доступ к АПИ
        // https://st.yandex-team.ru/DIRECT-53676
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(managerClientLogin);
        Long managerClientUid = jooqDbSteps.usersSteps().getUidByLogin(managerClientLogin);
        jooqDbSteps.usersSteps().setUsersHidden(managerClientUid, UsersHidden.Yes);

        api.userSteps.imagesSteps().configLoginImages(managerClientLogin, ImageType.WIDE, 1, 2);

        clients = api.as(Logins.AGENCY_YE_DEFAULT).userSteps.clientSteps()
                .getSubClientsNotArch(Logins.AGENCY_YE_DEFAULT);
        String agencyClientLogin = clients.get(4).getLogin();
        String agencyClientLoginAnother = clients.get(6).getLogin();

        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN, managerClientLogin, agencyClientLoginAnother},
                {Logins.SUPPORT, agencyClientLogin, managerClientLoginAnother},
                {Logins.PLACER, agencyClientLogin, managerClientLoginAnother},
                {Logins.SUPER_READER, managerClientLogin, agencyClientLoginAnother},
                {Logins.MEDIA, managerClientLogin, managerClientLoginAnother},
                {Logins.MANAGER_DEFAULT, managerClientLogin, managerClientLoginAnother},
                {Logins.AGENCY_YE_DEFAULT, agencyClientLogin, agencyClientLoginAnother}
        });
    }

    @Parameterized.Parameter
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String login;

    @Parameterized.Parameter(value = 2)
    public String loginAnother;

    @Before
    public void initCampaign() {
        List<CampaignGetItem> campaigns =
                api.as(operator).userSteps.campaignStepsV5().getCampaigns(login);
        assumeThat("вернулись кампании пользователя", campaigns.size(), greaterThan(0));
        campaignID = campaigns.get(0).getId();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7566")
    public void getWithNoSetFilter() {
        api.as(operator).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                        ),
                new AxisError(
                        71,
                        AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "SelectionCriteria.Logins")

        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7564")
    public void getByNullLoginArray() {
        api.as(operator).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withCampaignIDS(campaignID.intValue())
                        ),
                new AxisError(
                        71,
                        AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, "SelectionCriteria.Logins")

        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7567")
    public void getByNoDirectClientLogin() {
        //https://jira.yandex-team.ru/browse/DIRECT-29439
        api.as(operator).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withLogins(Logins.NO_DIRECT_CLIENT)
                        ),
                new AxisError(
                        251,
                        AxisErrorDetails.INVALID_IMAGE_OWNER)

        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7565")
    public void getByEmptyArray() {
        api.as(operator).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withLogins(new String[]{})
                                        .withCampaignIDS(campaignID.intValue())
                        ),
                new AxisError(
                        30,
                        AxisErrorDetails.THE_ARRAY_CANNOT_BE_EMPTY, "SelectionCriteria.Logins")

        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7568")
    public void getByOverMaxNumberOfLogins() {
        String[] logins = new String[ImagesSteps.AD_IMAGE_GET_LOGIN_MAX_COUNT + 1];
        Arrays.fill(logins, login);
        api.as(operator).userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withLogins(logins)
                        ),
                new AxisError(
                        241,
                        AxisErrorDetails.THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
                        "SelectionCriteria.Logins",
                        ImagesSteps.AD_IMAGE_GET_LOGIN_MAX_COUNT)
        );
    }
}
