package ru.yandex.autotests.directapi.images.association.get;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.common.api45.ShortClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetAssociationsByLoginTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @Parameterized.Parameters(name = "Login: {0}")
    public static Collection roleValues() {
        List<ShortClientInfo> clients = api.as(Logins.MANAGER_DEFAULT).userSteps.clientSteps()
                .getSubClientsNotArch(Logins.MANAGER_DEFAULT);
        String managerClientLogin = clients.get(2).getLogin();
        String managerClientLoginAnother = clients.get(3).getLogin();

        api.userSteps.imagesSteps().configLoginImages(managerClientLogin, ImageType.REGULAR, 1, 2);

        clients = api.as(Logins.AGENCY_YE_DEFAULT).userSteps.clientSteps()
                .getSubClientsNotArch(Logins.AGENCY_YE_DEFAULT);
        String agencyClientLogin = clients.get(2).getLogin();
        String agencyClientLoginAnother = clients.get(3).getLogin();

        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN, managerClientLogin, agencyClientLoginAnother},
                {Logins.SUPPORT, agencyClientLogin, managerClientLoginAnother},
                {Logins.PLACER, agencyClientLogin, managerClientLoginAnother},
                {Logins.SUPER_READER, managerClientLogin, agencyClientLoginAnother},
                {Logins.MEDIA, managerClientLogin, managerClientLoginAnother},
                {Logins.MANAGER_DEFAULT, managerClientLogin, managerClientLoginAnother},
                {Logins.AGENCY_YE_DEFAULT, agencyClientLogin, agencyClientLoginAnother}
        });
    }

    @Parameterized.Parameter
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String login;

    @Parameterized.Parameter(value = 2)
    public String loginAnother;
    
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7569")
    public void getByLogin() {
        AdImageAssociationResponse response = api.as(operator).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withLogins(login)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes.size(), greaterThanOrEqualTo(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7570")
    public void getByLogins() {
        AdImageAssociationResponse response = api.as(operator).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withLogins(login,loginAnother)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes.size(), greaterThanOrEqualTo(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7571")
    public void getByMaxNumberOfLogins() {
        String[] logins = new String[ImagesSteps.AD_IMAGE_GET_LOGIN_MAX_COUNT];
        Arrays.fill(logins, login);
        AdImageAssociationResponse response = api.as(operator).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withLogins(logins)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes.size(), greaterThanOrEqualTo(0));
    }
}
