package ru.yandex.autotests.directapi.images.association.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@Tag(TagDictionary.TRUNK)
public class GetAssociationsByStatusTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String assignedHash1;
    private static String assignedHash2;
    private static Long campaignID;

    @BeforeClass
    public static void initTest() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2);
        assignedHash1 = hashes[0];
        assignedHash2 = hashes[1];
        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, login,2);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(0), assignedHash1);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(1), assignedHash2);
        api.userSteps.adsSteps().adsModerate(login, adIDs.get(0), adIDs.get(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7574")
    public void getByNullStatusArray() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7572")
    public void getByEmptyArray() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withStatusAdImageModerate()
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7573")
    public void getByStatus() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withStatusAdImageModerate(Status.PENDING)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7575")
    public void getByStatuses() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withStatusAdImageModerate(Status.PENDING, Status.NEW)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7576")
    public void getByYesStatuses() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withStatusAdImageModerate(Status.YES)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7577")
    public void getByNoStatuses() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withStatusAdImageModerate(Status.NO)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7578")
    public void getByInvalidStatus() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withStatusAdImageModerate("status")),
                new AxisError(71, AxisErrorDetails.ARRAY_MUST_CONTAIN_VALUES,
                        "SelectionCriteria.StatusAdImageModerate", "New, Pending, Yes, No")
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7579")
    public void getByEmptyStatus() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withStatusAdImageModerate("")),
                new AxisError(71, AxisErrorDetails.ARRAY_MUST_CONTAIN_VALUES,
                        "SelectionCriteria.StatusAdImageModerate", "New, Pending, Yes, No")
        );
    }
}
