package ru.yandex.autotests.directapi.images.association.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
public class GetAssociationsPagerTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_7;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String assignedHash1;
    private static String assignedHash2;
    private static Long campaignID;

    @BeforeClass
    public static void initTest() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2);
        assignedHash1 = hashes[0];
        assignedHash2 = hashes[1];
        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, login, 2);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(0), assignedHash1);
        api.userSteps.imagesSteps().setAdImageAssociation(adIDs.get(1), assignedHash2);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7580")
    public void getHead() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withOffset(0)
                        .withLimit(1)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7581")
    public void getBody() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withOffset(1)
                        .withLimit(1)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7582")
    public void getOverTail() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withOffset(1)
                        .withLimit(2)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7583")
    public void getNextAfterTail() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withOffset(2)
                        .withLimit(2)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7584")
    public void requestEmptyLimitWithOffset() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withOffset(1)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7585")
    public void requestNegativeLimit() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withCampaignIDS(campaignID.intValue())
                                        .withLimit(-10)
                        ),
                new AxisError(71,
                        AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE, "SelectionCriteria.Limit")
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7586")
    public void requestOverLimit() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withCampaignIDS(campaignID.intValue())
                                        .withLimit(ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE+1)
                        ),
                new AxisError(71,
                        AxisErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_GREATER_THAN, "SelectionCriteria.Limit", 
                        ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7587")
    public void requestMaxLimit() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withCampaignIDS(campaignID.intValue())
                        .withLimit(ImagesSteps.AD_IMAGE_HASHES_MAX_VALUE)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, hasItems(assignedHash1, assignedHash2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7588")
    public void requestNegativeOffset() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withCampaignIDS(campaignID.intValue())
                                        .withOffset(-10)
                        ),
                new AxisError(71,
                        AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE, "SelectionCriteria.Offset")
        );
    }
}
