package ru.yandex.autotests.directapi.images.association.get;

import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

/**
 * Created by ginger on 03.08.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class GetForNonTextCampaignTest {
    public static String client = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_15;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;
    private static Long nonTextAdID;
    private static Long textAdID;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE}});
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns(){
        api.as(client);
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1, 2);
        String assignedHash1 = hashes[0];
        String assignedHash2 = hashes[1];
        nonTextCampaignId = api.userSteps.campaignStepsV5().addDefaultTextCampaign(client);
        Long nonTextAdGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(nonTextCampaignId, client);
        nonTextAdID = api.userSteps.adsSteps().addDefaultTextAd(nonTextAdGroupID, client);

        textCampaignId = api.userSteps.campaignStepsV5().addDefaultTextCampaign(client);
        Long textAdGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId, client);
        textAdID = api.userSteps.adsSteps().addDefaultTextAd(textAdGroupID, client);

        api.userSteps.imagesSteps().setAdImageAssociation(nonTextAdID, assignedHash1);
        api.userSteps.imagesSteps().setAdImageAssociation(textAdID, assignedHash2);
    }

    @Before
    public void setType(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7593")
    public void getAssociationOfNonTextCampaignByAdID(){
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withLogins(client)
                                        .withAdIDS(nonTextAdID)
                        ),
                new AxisError(3500)
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7594")
    public void getAssociationOfNonTextCampaignByCampaignID(){
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withLogins(client)
                                        .withCampaignIDS(nonTextCampaignId.intValue())
                        ),
                new AxisError(3500)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7595")
    public void getAssociationOfNonTextAndTextCampaignByAdID(){
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withLogins(client)
                                        .withAdIDS(nonTextAdID, textAdID)
                        ),
                new AxisError(3500)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7596")
    public void getAssociationOfNonTextAndTextCampaignByCampaignID(){
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withLogins(client)
                                        .withCampaignIDS(nonTextCampaignId.intValue(), textCampaignId.intValue())
                        ),
                new AxisError(3500)
        );
    }

    @AfterClass
    public static void setTextTypeToDeleteImage(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, CampaignsType.TEXT);
    }
}
