package ru.yandex.autotests.directapi.images.association.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationRequestMap;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.empty;
import static org.junit.Assert.assertThat;

/**
 * Created by pavryabov on 27.07.16.
 * https://st.yandex-team.ru/TESTIRT-9783
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_GET)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-54755")
@Description("Вызов AdImageAssociation.get для графического баннера")
public class GetImageAdTest {

    private static final String LOGIN = ImageLogins.LOGIN_GET_IMAGES_6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textCampaignId;
    private static Long textImageAdId;
    private static Long mobileAppCampaignId;
    private static Long mobileAppImageAdId;
    private static String adImageHash;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void prepareData() {
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(3);
        textCampaignId = api.userSteps.campaignStepsV5().addDefaultTextCampaign();
        Long textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(textAdGroupId, adImageHash);
        mobileAppCampaignId = api.userSteps.campaignStepsV5().addDefaultMobileAppCampaign();
        Long mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);
    }

    @Test
    public void getByTextImageAdId() {
        //DIRECT-56607
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withAdIDS(textImageAdId)
                        ),
                new AxisError(3500, AxisErrorDetails.BANNER_TYPE_NOT_SUPPOTED_BANNERS, textImageAdId)
        );
    }

    @Test
    public void getByMobileAppImageAdId() {
        api.userSteps.imagesSteps().shouldGetErrorOn(
                Method.AD_IMAGE_ASSOCIATION,
                new AdImageAssociationRequestMap(api.type())
                        .get(
                                new AdImageAssociationSelectionCriteriaMap(api.type())
                                        .withAdIDS(mobileAppImageAdId)
                        ),
                new AxisError(3500)
        );
    }

    @Test
    public void getByAdImageHash() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().getAdImageAssociation(
                new AdImageAssociationSelectionCriteriaMap(api.type())
                        .withAdImageHashes(adImageHash)
        );
        List<String> gotHashes = extract(response.getAdImageAssociations(),
                on(AdImageAssociation.class).getAdImageHash());
        assertThat(gotHashes, empty());
    }
}
