package ru.yandex.autotests.directapi.images.association.set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociation;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationSelectionCriteria;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import java.util.Arrays;
import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsEqual.equalTo;

/**
 * User: mariabye
 * Date: 17.09.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_SET)
@Stories(ApiStories.GROUPS)
@Tag(TagDictionary.TRUNK)
public class AdGroupImageTest {

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_11;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long bannerID1;
    private static Long bannerID2;
    private static String[] hashes;

    @BeforeClass
    public static void testCampaign() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, 2);
        bannerID1 = adIDs.get(0);
        bannerID2 = adIDs.get(1);

        hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7597")
    public void assignImagesToBannerInGroupTest() {
        api.userSteps.imagesSteps().setAdImageAssociation(bannerID1, hashes[0]);
        api.userSteps.imagesSteps().setAdImageAssociation(bannerID2, hashes[1]);
        AdImageAssociation[] adImageAssociations =
                ((AdImageAssociationResponse) api.userSteps.imagesSteps().getAdImageAssociation(
                        new AdImageAssociationSelectionCriteriaMap<>(new AdImageAssociationSelectionCriteria())
                                .withAdIDS(bannerID1, bannerID2)))
                        .getAdImageAssociations();
        List<String> groupHashes = extract(adImageAssociations, on(AdImageAssociation.class).getAdImageHash());
        assertThat("Неверный список полученных хэшей для привязанных картинок",
                groupHashes, equalTo(Arrays.asList(hashes)));
    }

}
