package ru.yandex.autotests.directapi.images.association.set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.*;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * Created by chicos on 22.07.14.
 *
 * https://jira.yandex-team.ru/browse/DIRECT-33400
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_SET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AdImageHashValidationTest {

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_11;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adID;

    @Parameterized.Parameter(value = 0)
    public String hashValue;

    @Parameterized.Parameter(value = 1)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "hash = {0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {"Котик", new AxisError(71, AxisErrorDetails.IMAGE_FIELD_MUST_BE_BASE64_ENCODED, "AdImageAssociations[0].AdImageHash")},
                {"23symbolsLengthHk2JJjkj", new AxisError(71, AxisErrorDetails.LENGTH_OF_BASE64_FIELD_SHOULD_NOT_EXCEED, "AdImageAssociations[0].AdImageHash", 22)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createBannerGroup() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, login, 2);
        adID = adIDs.get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7598")
    public void setAdImageInvalidHashTest() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().setAdImageAssociation(
                adID,
                hashValue
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                expectedError);
    }
}
