package ru.yandex.autotests.directapi.images.association.set;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by voronov on 17.05.2016.
 * https://st.yandex-team.ru/TESTIRT-9246
 */

@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_SET)
public class AgencyAssignImageToAdTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String agency = ImageLogins.AGENCY_ASSOCIATION_EXTRA_SHARD;

    private static String subclient1 = ImageLogins.SUBCLIENT_1_ASSOCIATION_DEFAULT_SHARD;
    private static String subclient2 = ImageLogins.SUBCLIENT_2_ASSOCIATION_DEFAULT_SHARD;

    private static Long campaignID1;
    private static Long campaignID2;

    private static Long adID1;
    private static Long adID2;

    private static AdImage adImage;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agency).version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initCampaign() {

        api.userSteps.clientFakeSteps().reshardUserWithLock(agency, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient2, ShardNumbers.DEFAULT_SHARD);

        campaignID1 = api.userSteps.campaignStepsV5().addDefaultTextCampaign(subclient1);
        Long adGroupID1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID1, subclient1);
        adID1 = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(new TextAdAddMap().defaultTextAd())
                        .withAdGroupId(adGroupID1),
                subclient1);

        campaignID2 = api.userSteps.campaignStepsV5().addDefaultTextCampaign(subclient2);
        Long adGroupID2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID2, subclient2);
        adID2 = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(new TextAdAddMap().defaultTextAd())
                        .withAdGroupId(adGroupID2),
                subclient2);

        api.userSteps.imagesSteps().adImageDeleteForLogin(subclient1);
        api.userSteps.imagesSteps().adImageDeleteForLogin(subclient2);

        adImage = api.userSteps.imagesSteps().uploadRawImage("star", "https://direct-qa.s3.mds.yandex.net/images/start.png", subclient1);

        api.userSteps.getDirectJooqDbSteps().useShard(ShardNumbers.EXTRA_SHARD.getShardNumber())
                .imagesSteps().deleteBannerImagesFormatsRecord(adImage.getAdImageHash());
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-54173")
    @Description("Агентство, расположенное в одном шарде, привязывает изображение к баннеру своего клиента, расположенного в другом шарде")
    public void agencyAssignImageToAdInOtherShard() {
        api.userSteps.imagesSteps().setAdImageAssociation(adID1, adImage.getAdImageHash());

        String adImageHash = api.userSteps.adsSteps().getAdImageHash(adID1, subclient1);
        assertThat("Верное значение AdImageHash", adImageHash, equalTo(adImage.getAdImageHash()));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-54173")
    @Description("Агентство пытается привязать изображение одного своего клиента к баннеру другого своего клиента")
    public void agencyAssignOneClientImageToAdOfAnotherClient() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps()
                .setAdImageAssociation(adID2, adImage.getAdImageHash());

        api.userSteps.imagesSteps().responseShouldContainErrors(
                response, new AxisError(271, AxisErrorDetails.IMAGE_NOT_FOUND));
    }
}
