package ru.yandex.autotests.directapi.images.association.set;

import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_SET)
@RunWith(Parameterized.class)
public class InternalRoleAccess {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_9;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static String imageHash;
    private static Long campaignID;

    @BeforeClass
    public static void initTest() {
        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
    }

    @Parameterized.Parameters(name = "Login: {0}")
    public static Collection roleValues() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.WIDE, 2);

        imageHash = hashes[0];
        return Arrays.asList(new Object[][]{
                {ImageLogins.SUPER_LOGIN, equalTo(imageHash)},
                {ImageLogins.SUPER_READER, equalTo(null)},
                {ImageLogins.SUPPORT, equalTo(imageHash)},
                {ImageLogins.PLACER, equalTo(imageHash)},
                {ImageLogins.MEDIA, equalTo(null)}
        });
    }

    @Parameterized.Parameter
    public String operator;
    @Parameterized.Parameter(value = 1)
    public Matcher<String> matcher;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7613")
    public void assignImageToAd() {
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        Long adID = api.userSteps.adsSteps().addDefaultTextAd(groupID, login);

        api.as(operator).userSteps.imagesSteps().setAdImageAssociation(adID, imageHash);

        String adImageHash = api.userSteps.adsSteps().getAdImageHash(adID, login);
        assertThat("Неверное значение AdImageHash", adImageHash, matcher);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7612")
    public void unAssignImageToAd() {
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        Long adID = api.userSteps.adsSteps().addDefaultTextAd(groupID, login);

        api.as(operator).userSteps.imagesSteps().setAdImageAssociation(adID, imageHash);
        api.as(operator).userSteps.imagesSteps().setAdImageAssociation(adID, null);

        String adImageHash = api.userSteps.adsSteps().getAdImageHash(adID, login);
        assertThat("Неверное значение AdImageHash", adImageHash, equalTo(null));
    }

}
