package ru.yandex.autotests.directapi.images.association.set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 27.07.16.
 * https://st.yandex-team.ru/TESTIRT-9783
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_SET)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-54755")
@Description("Вызов AdImageAssociation.get для графического баннера или для новой картинки")
public class SetImageAdTest {

    private static final String LOGIN = ImageLogins.LOGIN_GET_IMAGES_6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textImageAdId;
    private static Long mobileAppImageAdId;
    private static Long textAdId;
    private static String adImageHash;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void prepareData() {
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(3);
        Long textCampaignId = api.userSteps.campaignStepsV5().addDefaultTextCampaign();
        Long textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(textAdGroupId, adImageHash);
        textAdId = api.userSteps.adsSteps().addDefaultTextAd(textAdGroupId);
        Long mobileAppCampaignId = api.userSteps.campaignStepsV5().addDefaultMobileAppCampaign();
        Long mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);
    }

    @Test
    public void setToTextImageAdId() {
        //DIRECT-56607
        AdImageAssociationResponse response = api.userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(textImageAdId)
                        .withAdImageHash(adImageHash)
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(3500, AxisErrorDetails.BANNER_TYPE_NOT_SUPPOTED));
    }

    @Test
    public void setToMobileAppImageAdId() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(mobileAppImageAdId)
                        .withAdImageHash(adImageHash)
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(3500));
    }

    @Test
    public void setNewImageToTextAdId() {
        AdImageAssociationResponse response = api.userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(textAdId)
                        .withAdImageHash(adImageHash)
        );
        api.userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(272, AxisErrorDetails.IMAGE_SIZE_INVALID));
    }
}
