package ru.yandex.autotests.directapi.images.association.set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImageAssociationResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.List;

import static java.util.Arrays.asList;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 22.05.13
 */
@Aqua.Test
@Features(ImagesFeatures.AD_IMAGE_ASSOCIATION_SET)
@Tag(TagDictionary.TRUNK)
public class UnAssignImageToAdTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = ImageLogins.LOGIN_WITH_ASSIGNED_IMAGES_10;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long campaignID;
    private static Long adGroupID;
    private static Long adID1;
    private static Long adID2;
    private static Long adID3;
    private static String[] hashes;

    @BeforeClass
    public static void initTest() {
        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        List<Long> adIDs = api.userSteps.adsSteps().addDefaultTextAds(adGroupID, login, 3);
        adID1 = adIDs.get(0);
        adID2 = adIDs.get(1);
        adID3 = adIDs.get(2);

        hashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2, 3);
        api.userSteps.imagesSteps().setAdImageAssociation(adID3, hashes[0]);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7621")
    public void unAssignImageToAd() {
        api.as(login).userSteps.imagesSteps().setAdImageAssociation(adID1, hashes[0]);

        api.as(login).userSteps.imagesSteps().setAdImageAssociation(adID1, null);
        String adImageHash = api.userSteps.adsSteps().getAdImageHash(adID1, login);
        assertThat("Неверное значение AdImageHash", adImageHash, nullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7624")
    public void unAssignImageToNegativeAdID() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().setAdImageAssociation(
                -adID1, null
        );
        api.as(login).userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(71,
                        AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
                        "AdImageAssociations[0].AdID"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7622")
    public void unAssignImageToNoRightAdID() {
        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().setAdImageAssociation(
                3054L, null
        );
        api.as(login).userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7625")
    public void unAssignImageToNoExistAdID() {
        Long adID = api.as(login).userSteps.adsSteps().addDefaultTextAd(adGroupID);
        api.userSteps.adsSteps().adsDelete(login, adID);

        AdImageAssociationResponse response = api.as(login).userSteps.imagesSteps().setAdImageAssociation(
                adID,null);
        api.as(login).userSteps.imagesSteps().responseShouldContainErrors(
                response,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7626")
    public void unAssignImageToAdIDWithNoAssignedImage() {
        api.as(login).userSteps.imagesSteps().setAdImageAssociation(adID1, null);
        api.as(login).userSteps.imagesSteps().setAdImageAssociation(adID1, null);

        String adImageHash = api.userSteps.adsSteps().getAdImageHash(adID1, login);
        assertThat("Неверное значение AdImageHash", adImageHash, nullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7623")
    public void unAssignSomeImagesToAds() {
        api.as(login).userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(adID1)
                        .withAdImageHash(hashes[0]),
                new AdImageAssociationMap(api.type())
                        .withAdID(adID2)
                        .withAdImageHash(hashes[1])
        );

        api.as(login).userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(adID1)
                        .withAdImageHash(null),
                new AdImageAssociationMap(api.type())
                        .withAdID(adID2)
                        .withAdImageHash(null)
        );

        List<String> adImageHashes = asList(api.userSteps.adsSteps().getAdImageHash(adID1, login),
                api.userSteps.adsSteps().getAdImageHash(adID2, login));
        assertThat("Неверное значение AdImageHash", adImageHashes, equalTo(asList((String) null, null)));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7627")
    public void unAssignAndAssignImageToSameAd() {
        api.as(login).userSteps.imagesSteps().setAdImageAssociation(adID1, hashes[0]);


        api.as(login).userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(adID1)
                        .withAdImageHash(hashes[0]),
                new AdImageAssociationMap(api.type())
                        .withAdID(adID1)
                        .withAdImageHash(null)
        );
        String adImageHash = api.userSteps.adsSteps().getAdImageHash(adID1, login);

        assertThat("Неверное значение AdImageHash", adImageHash, nullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7628")
    public void assignAndUsAssignImageToSameAd() {
        api.as(login).userSteps.imagesSteps().setAdImageAssociation(adID1, hashes[0]);


        api.as(login).userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(adID1)
                        .withAdImageHash(null),
                new AdImageAssociationMap(api.type())
                        .withAdID(adID1)
                        .withAdImageHash(hashes[0])
        );
        String adImageHash = api.userSteps.adsSteps().getAdImageHash(adID1, login);

        assertThat("Неверное значение AdImageHash", adImageHash, nullValue());
    }

}
