package ru.yandex.autotests.directapi.images.norun;

import org.junit.Test;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.qatools.elliptics.ElAction;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import static ru.yandex.qatools.elliptics.ElClient.elliptics;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 23.05.13
 * Time: 13:04
 * To change this template use File | Settings | File Templates.
 */
public class LoadImagesToEllipticsTest {
    //http://aqua.yandex-team.ru/storage/get/indefinitely/direct/images/valid/img10.jpg
    List<String> url = new ArrayList<String>() {{
        add("http://bezdna.moy.su/_fr/6/0233586.jpg");//150x150
        add("http://www.o5wap.ru/content/_cashe/e/8/c/e8c619fe1ddacb71345850864aea464b2.jpg");//150x200
        add("http://www.sunhome.ru/images/holiday/Vajju.jpg");//200x150
        add("http://mtbtour.com.ua/image_country/23.jpg");//150x170
        add("https://dl.dropboxusercontent.com/u/72400468/180x150_2.gif");//gif 180x150
        add("http://s006.radikal.ru/i214/1403/a0/54adaafe16ae.png");//png 150x150
        add("http://houseonly.ru/wp-content/uploads/2011/05/Summer-House-Music-2011-150x150.jpg");//150x150
        add("http://img0.liveinternet.ru/images/attach/c/2/70/248/70248525_1296494551_1.jpg");//150x150
        add("http://www.activeclub.com.ua/modules/gallery/d/10133-2/nature_243.jpg"); //150x150
        add("http://bglady.net/wp-content/uploads/2012/07/summer-at-lonely-beach-1440x9001-150x150.jpg"); //150x150
        add("http://rookery.s3.amazonaws.com/830500/830892_5bd7_sqr.jpg"); //150x150
    }};
    //http://aqua.yandex-team.ru/storage/get/indefinitely/direct/images/invalid/rate/img1.jpg
    List<String> inValidRate = new ArrayList<String>() {{
        add("http://img-fotki.yandex.ru/get/3212/a08918410820.4/0_4aa3_9a6909e4_L");//149x150
        add("http://s016.radikal.ru/i335/1403/9e/11266c8d3672.jpg");//150x149
        add("http://stat8.blog.ru/lr/0b0d571bbebbe518e66085391ba68577");//149x149
        add("http://www.bezformata.ru/content/Images/000/002/913/image2913397.jpg");//150x201
        add("http://cs302707.userapi.com/v302707958/cd5/Kuyu2wz8k-E.jpg");//201x150
        add("http://dnepr.info/topimg/43836/1217232233_1.jpg");//151x151
    }};

    List<String> inValidRateLocal = new ArrayList<String>() {{
        add("test.bmp");//150x150
        add("images/invalid/img8.jpg.bmp");
    }};

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7629")
    public void loadExternalImagesToElliptics() {
        String storagePath = "direct/images/valid";
        for (int i = 0; i < url.size(); i++) {
            String path = String.format("/img%s.jpg", i+1);
            try {
                InputStream iReport = new URL(url.get(i)).openStream();
                ElAction report = elliptics()
                        .indefinitely()
                        .path(storagePath)
                        .name(path)
                        .update(iReport);
                iReport.close();
                System.out.println("Файл записан и доступен по адресу: ");
                report.log().asLink();
            } catch (Exception e) {
                throw new DirectAPIException("Ошибка записи отчета в элиптикс", e);
            }
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7630")
    public void loadExternalImagesToEllipticsInvalidRate() {
        String storagePath = "direct/images/invalid/rate";
        for (int i = 0; i < inValidRate.size(); i++) {
            String path = String.format("/img%s.jpg", i+1);
            try {
                InputStream iReport = new URL(inValidRate.get(i)).openStream();
                ElAction report = elliptics()
                        .indefinitely()
                        .path(storagePath)
                        .name(path)
                        .update(iReport);
                iReport.close();
                System.out.println("Файл записан и доступен по адресу: ");
                report.log().asLink();
            } catch (Exception e) {
                throw new DirectAPIException("Ошибка записи отчета в элиптикс", e);
            }
        }
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7631")
    public void loadResourceImagesToEllipticsInvalidRate() {
        String storagePath = "direct/images/invalid/rate";
        for (int i = 0; i < inValidRateLocal.size(); i++) {
            String path = String.format("/img%s.jpg", inValidRate.size()+i+1);
            try {
                InputStream iReport = getClass().getClassLoader().getResourceAsStream(inValidRateLocal.get(i));
                ElAction report = elliptics()
                        .indefinitely()
                        .path(storagePath)
                        .name(path)
                        .update(iReport);
                iReport.close();
                System.out.println("Файл записан и доступен по адресу: ");
                report.log().asLink();
            } catch (Exception e) {
                throw new DirectAPIException("Ошибка записи отчета в элиптикс", e);
            }
        }
    }
}
