package ru.yandex.autotests.directapi.images.smoke;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.common.api45.AdImageUpload;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Author pavryabov
 * Date 09.04.14
 */
@Aqua.Test
@Features(ImagesFeatures.IMAGE_MONITOR)
@Stories(ImagesFeatures.AD_IMAGE_UPLOAD)
public class UploadImageUrlSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.IMAGE_SMOKE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104)
            .as(Logins.SUPER_LOGIN, login);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @BeforeClass
    public static void deleteImages() {
        api.userSteps.imagesSteps().adImageDeleteForLogin(login);
    }

    @Test
    @Title("Загрузка картинки")
    @ru.yandex.qatools.allure.annotations.TestCaseId("7632")
    public void couldUploadImage() {
        int taskID =
                api.userSteps.imagesSteps().putImageInUploadQueue(login, ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR), "Name");
        Object[] images = api.userSteps.imagesSteps().waitForImageHandleResult(taskID);
        assertThat("Ошибка при загрузке картинки", ((AdImageUpload)images[0]).getStatus(), equalTo(Status.DONE));
    }
}
