package ru.yandex.autotests.directapi.images.units;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.common.api45.ClientsUnitInfo;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.images.AdImageAssociationMap;
import ru.yandex.autotests.directapi.model.images.AdImageRawMap;
import ru.yandex.autotests.directapi.model.images.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 05.06.13
 */
@Aqua.Test
@Features(ImagesFeatures.ADIMAGE)
@Stories(ApiStories.UNITS)
public class ImageUnitsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = ImageLogins.LOGIN_FOR_IMAGE_UNITS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String[] imageHash;

    @BeforeClass
    public static void loadImages() {
        imageHash = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 1, 2, 3, 4);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7633")
    public void deleteImageSuccessTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageDelete(imageHash[0]);
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7634")
    public void deleteImageFailureTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        try {
            api.userSteps.imagesSteps().adImageDelete("asdfasdfasdfasdf");
        } catch (AxisError axisError) {
            log.info("Получили запланировнную ошибку");
        }

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7635")
    public void getImageSuccessTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().getAdImage(imageHash[1], login);
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7636")
    public void getImageFailureTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().getAdImage("asdfasdfasdfasdf");
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7637")
    public void getLimitsSuccessTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().getLimits(login);
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7638")
    public void uploadRawImageSuccessTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().adImageUploadRawData(
                ImagesSteps.nameValidRegularImages.get(3),
                ImagesSteps.getDefaultImageUrl(3, ImageType.REGULAR),
                login
        );

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 2));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7639")
    public void uploadRawImagesSuccessTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageUploadRawData(
                new AdImageRawMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameValidRegularImages.get(4))
                        .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR))),
                new AdImageRawMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameValidRegularImages.get(5))
                        .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getDefaultImageUrl(5, ImageType.REGULAR)))
        );
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 4));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7640")
    public void uploadRawImagesFailedTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageUploadRawData(
                new AdImageRawMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameValidRegularImages.get(6))
                        .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getDefaultImageUrl(6, ImageType.REGULAR))),
                new AdImageRawMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameInvalidBigImages.get(1))
                        .withRawData(ImageBase64Utils.getBase64EncodedFileData(ImagesSteps.getInvalidImageUrl(1, ImageType.REGULAR)))
        );
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 2));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7641")
    public void uploadUrlImageSuccessTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameValidRegularImages.get(7))
                        .withURL(ImagesSteps.getDefaultImageUrl(7, ImageType.REGULAR)));
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 2));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7642")
    public void uploadUrlImagesSuccessTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameValidWideImages.get(1))
                        .withURL(ImagesSteps.getDefaultImageUrl(1, ImageType.WIDE)),
                new AdImageURLMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameValidWideImages.get(1))
                        .withURL(ImagesSteps.getDefaultImageUrl(1, ImageType.WIDE)));
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 4));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7643")
    public void uploadUrlImagesFailedTest() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageUpload(
                new AdImageURLMap(api.type())
                        .withLogin(login)
                        .withName(ImagesSteps.nameValidWideImages.get(1))
                        .withURL(""));
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7644")
    public void checkUploadStatusSuccessCost() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type()).withLogins(login)
        );
        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7645")
    public void checkUploadStatusFailedCost() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        api.userSteps.imagesSteps().adImageCheckUploadStatus(
                new AdImageSelectionCriteriaMap(api.type()).withLogins(login)
                        .withAdImageUploadTaskIDS(1)
        );

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }


    //region assign cost
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7646")
    public void assignImageToDraftAdCost() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        Long adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);

        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(adID, imageHash[2]);

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7647")
    public void assignImageToSendToModerateAdCost() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        api.userSteps.keywordsSteps().addDefaultKeyword(login, adGroupID);
        Long adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        api.userSteps.adsSteps().adsModerate(adID);

        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(adID, imageHash[2]);

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 2));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7648")
    public void assignImageToAdFailCost() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(1L, imageHash[2]);

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7649")
    public void assignImagesToAdsCost() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        Long draftAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        Long moderatedAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        api.userSteps.bannersFakeSteps().makeBannersModerated(moderatedAdID);

        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(draftAdID)
                        .withAdImageHash(imageHash[2]),
                new AdImageAssociationMap(api.type())
                        .withAdID(moderatedAdID)
                        .withAdImageHash(imageHash[2]));


        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 2));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }
    //endregion


    //region unAssign cost
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7650")
    public void unAssignImageFromDraftAdCost() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        Long adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        api.userSteps.imagesSteps().setAdImageAssociation(adID, imageHash[2]);

        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(adID, null);

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7651")
    public void unAssignImageToSendToModerateAdCost() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        api.userSteps.keywordsSteps().addDefaultKeyword(login, adGroupID);
        Long adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        api.userSteps.adsSteps().adsModerate(adID);
        api.userSteps.imagesSteps().setAdImageAssociation(adID, imageHash[2]);

        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(adID, null);

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 1));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7652")
    public void unAssignImageToAdFailCost() {
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(1L, null);

        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 0));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7653")
    public void unAssignImagesToAdsCost() {
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        Long draftAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        Long moderatedAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);
        api.userSteps.bannersFakeSteps().makeBannersModerated(moderatedAdID);

        api.userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(draftAdID)
                        .withAdImageHash(imageHash[2]),
                new AdImageAssociationMap(api.type())
                        .withAdID(moderatedAdID)
                        .withAdImageHash(imageHash[2]));
        int unitBefore = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();

        api.userSteps.imagesSteps().setAdImageAssociation(
                new AdImageAssociationMap(api.type())
                        .withAdID(draftAdID)
                        .withAdImageHash(null),
                new AdImageAssociationMap(api.type())
                        .withAdID(moderatedAdID)
                        .withAdImageHash(null));


        int unitAfter = ((ClientsUnitInfo) api.userSteps.clientSteps().getClientUnits(login)).getUnitsRest();
        assertThat("Списано неверное число баллов", unitAfter, equalTo(unitBefore - 1));
        log.info("Списано баллов: " + (unitBefore - unitAfter));
    }
    //endregion

}

