package ru.yandex.autotests.directapi.retargeting;

import java.util.Arrays;
import java.util.List;

import com.google.common.primitives.Ints;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.RetargetingSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * User: hmepas
 * Date: 12.10.16
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Чистим условия ретаргетинга на пользователе")
@RunWith(Parameterized.class)
public class ClearUsersUtil {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String login;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                /*{"at-retargeting-12"},
                {"at-update-client"},
                {"at-get-subcl1"},*/
                //{"at-get-subcl3"},
                //{"at-delete-subcl3"},
                //{"api-direct-retargeting17"},
                /*{"at-add-client"},
                {"at-direct-target56"},
                {"at-direct-target54"},
                {"api-direct-retargeting48"},
                {"api-direct-retargeting35"},
                {"api-direct-retargeting36"},
                {"at-retargeting-segment3"},
                {"at-client-webpages"},
                {"at-subclient-webpages"},*/
                //{"at-serv-webpages"},
                //{"api-direct-retargeting4"},
                //{"api-direct-retargeting29"},
                //{"api-direct-retargeting34"},
                //{"api-direct-retargeting17"}
                //{"api-direct-retargeting42"}
                //{"at-retargeting"},
                //{"at-direct-target32"}
                //{"at-retargeting-segment-1"},
                //{"at-retargeting"}
                /*,
                {"at-client-webpages"},
                {"api-direct-retargeting5"},
                {"api-direct-retargeting29"}*/
        });
    }

    @Test
    public void flushAllRetargetings() {
        final RetargetingSteps retargetingSteps = api.userSteps.retargetingSteps();
        api.userSteps.deleteAllRetargetingListsByLogin(login);
        final List<Integer> retargetingConditions = Ints.asList(retargetingSteps.getRetargetingConditions(login));
        assertThat("Пользователь пустой", retargetingConditions, Matchers.empty());
    }
}
