package ru.yandex.autotests.directapi.retargeting.getretargetinggoals;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalMap;
import ru.yandex.autotests.directapi.retargeting.RetargetingFeatures;
import ru.yandex.autotests.directapi.retargeting.RetargetingLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.stream.Stream;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 12.05.16.
 * https://st.yandex-team.ru/TESTIRT-5030
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-38428")
@Features(RetargetingFeatures.GET_RETARGETING_GOALS)
@Description("Проверяем, что не возвращается удаленный сегмент")
public class GetRetargetingGoalsDeletedSegmentTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String login = RetargetingLogins.LOGIN_WITH_SEGMENT;
    private static RetargetingGoal[] goals;
    public static long deletedGoalIdWithSegmentType = 1000007015;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        goals = api.userSteps.retargetingSteps().getRetargetingGoals(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6647")
    public void checkExistenceSegmentTypeInResponse() {
        long count = Stream.of(goals)
                .filter(goal -> new RetargetingGoalMap<>(goal)
                        .get(RetargetingGoalMap.GOAL_ID).equals(deletedGoalIdWithSegmentType))
                .count();
        assertThat("удаленная цель не найдена", count, equalTo(0l));
    }

}
