package ru.yandex.autotests.directapi.retargeting.getretargetinggoals;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.retargeting.GetRetargetingGoalsRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalMap;
import ru.yandex.autotests.directapi.retargeting.RetargetingFeatures;
import ru.yandex.autotests.directapi.retargeting.RetargetingLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.hasItems;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.matchers.arrays.ArraySizeMatcher.hasSize;

/**
 * User: mariabye
 * Date: 09.04.13
 */
@Aqua.Test
@Features(RetargetingFeatures.GET_RETARGETING_GOALS)
public class GetRetargetingGoalsRequestTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String LOGIN = RetargetingLogins.LOGIN_FOR_SEGMENT4;
    private static List<Long> clientGoals;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void initTest() {
        clientGoals = api.as(LOGIN).userSteps.retargetingSteps().getRetargetingGoalIDs(null);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6639")
    public void requestGoalsByClientLoginNotSpecified() {
        RetargetingGoal[] goals = api.as(LOGIN).userSteps.retargetingSteps().getRetargetingGoals((String) null);
        assertThat(extractProperty(goals, RetargetingGoalMap.GOAL_ID), hasItems(clientGoals.toArray()));
        assertThat(goals, hasSize(Matchers.greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6641")
    public void requestGoalsByClientLoginEmpty() {
        RetargetingGoal[] goals = api.as(LOGIN).userSteps.retargetingSteps().getRetargetingGoals(new String[0]);
        assertThat(extractProperty(goals, RetargetingGoalMap.GOAL_ID), hasItems(clientGoals.toArray()));
        assertThat(goals, hasSize(Matchers.greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6642")
    public void requestGoalsByClientLogin() {
        RetargetingGoal[] goals = api.as(LOGIN).userSteps.retargetingSteps().getRetargetingGoals(LOGIN);
        assertThat(extractProperty(goals, RetargetingGoalMap.GOAL_ID), hasItems(clientGoals.toArray()));
        assertThat(goals, hasSize(Matchers.greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6644")
    public void requestGoalsNoRightLoginFieldIgnored() {
        RetargetingGoal[] goals = api.as(LOGIN).userSteps.retargetingSteps().getRetargetingGoals("holodilnik.ru");
        assertThat(extractProperty(goals, RetargetingGoalMap.GOAL_ID), hasItems(clientGoals.toArray()));
        assertThat(goals, hasSize(Matchers.greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6637")
    public void requestGoalsByAgencyClientLoginNotSpecified() {
        GetRetargetingGoalsRequestMap request = new GetRetargetingGoalsRequestMap(api.type());
        api.as(Logins.AGENCY_YE_DEFAULT).userSteps.shouldGetErrorOn(
                Method.GET_RETARGETING_GOALS,
                request,
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        StringUtils.capitalize(GetRetargetingGoalsRequestMap.LOGINS))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6638")
    public void requestGoalsByAgencyLoginEmpty() {
        GetRetargetingGoalsRequestMap request = new GetRetargetingGoalsRequestMap(api.type()).withLogins(new String[0]);
        api.as(Logins.AGENCY_YE_DEFAULT).userSteps.shouldGetErrorOn(
                Method.GET_RETARGETING_GOALS,
                request,
                new AxisError(30, AxisErrorDetails.THE_ARRAY_CANNOT_BE_EMPTY,
                        StringUtils.capitalize(GetRetargetingGoalsRequestMap.LOGINS))
        );
    }

}
