package ru.yandex.autotests.directapi.retargeting.getretargetinggoals;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.util.streamex.StreamEx;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.retargeting.RetargetingFeatures;
import ru.yandex.autotests.directapi.retargeting.RetargetingLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 02.04.15.
 * https://st.yandex-team.ru/TESTIRT-5030
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-38428")
@Features(RetargetingFeatures.GET_RETARGETING_GOALS)
@Description("Проверяем, что возвращается поле Type с корректными значениями: segment, goal")
@RunWith(Parameterized.class)
public class GetRetargetingGoalsTypeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String login = RetargetingLogins.LOGIN_WITH_SEGMENT;
    private static final String loginForEcommerceGoals = RetargetingLogins.LOGIN_WITH_ECOMMERCE_GOALS;

    private static RetargetingGoal[] goals;

    public static long goalIdWithSegmentType = 1000007300;
    public static long goalIdWithGoalType = 4029459065L;
    public static long goalIdWithAudienceSegmentType = 2000110590L;

    /*
        По тикету https://st.yandex-team.ru/DIRECT-72245 добавили еще одного пользователя с ecommerce целями
        Это одно из его ecommerce целей
    */
    public static long goalIdWithEcommerceType =  3043798109L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public Long goalId;

    @Parameterized.Parameter(1)
    public String expectedType;

    @Parameterized.Parameters(name = "{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {goalIdWithSegmentType, RetargetingGoalType.SEGMENT.toString()},
                {goalIdWithGoalType, RetargetingGoalType.GOAL.toString()},
                {goalIdWithAudienceSegmentType, RetargetingGoalType.AUDIENCE_SEGMENT.toString()},
                {goalIdWithEcommerceType, RetargetingGoalType.ECOMMERCE.toString()}
        });
    }

    @BeforeClass
    public static void initTest() {
        RetargetingGoal[] goalsForLogin;
        goalsForLogin = api.userSteps.retargetingSteps().getRetargetingGoals(login);
        goals = api.as(Logins.SUPER_LOGIN, loginForEcommerceGoals).userSteps.retargetingSteps().getRetargetingGoals(loginForEcommerceGoals);

        // складываем в один массив цели обоих логинов
        goals = StreamEx.of(goals).append(goalsForLogin).collect(Collectors.toList()).toArray(new RetargetingGoal[goalsForLogin.length]);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6645")
    public void checkExistenceSegmentTypeInResponse() {
        RetargetingGoal goalWithRequiredType = Stream.of(goals)
                .filter(goal -> new RetargetingGoalMap<>(goal)
                        .get(RetargetingGoalMap.GOAL_ID).equals(goalId))
                .findFirst()
                .get();
        assumeThat("цель получена", goalWithRequiredType, notNullValue());
        assertThat("тип цели совпал с ожидаемой",
                goalWithRequiredType.getType(), equalTo(expectedType));
    }

}
