package ru.yandex.autotests.directapi.retargeting.getretargetinggoals;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.retargeting.RetargetingFeatures;
import ru.yandex.autotests.directapi.retargeting.RetargetingStories;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.greaterThan;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.matchers.arrays.ArraySizeMatcher.hasSize;

/**
 * User: mariabye
 * Date: 09.04.13
 */
@Aqua.Test
@Features(RetargetingFeatures.GET_RETARGETING_GOALS)
@Stories(RetargetingStories.RETARGETING_INTERNAL_ROLES)
@RunWith(Parameterized.class)
public class InternalRolesTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN},
                {Logins.SUPER_READER},
                {Logins.SUPPORT},
                {Logins.PLACER},
                {Logins.MEDIA},
                {Logins.MANAGER_DEFAULT},
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6648")
    public void requestGoalsByLogin() {
        RetargetingGoal[] goals = api.as(login).userSteps.retargetingSteps()
                .getRetargetingGoals(Logins.CLIENT_FREE_YE_DEFAULT);
        assertThat("Не получен список целей", goals, hasSize(greaterThan(0)));
        log.info("Цели получены.");
    }

}
