package ru.yandex.autotests.directapi.retargeting.production;

import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalMap;
import ru.yandex.autotests.directapi.retargeting.RetargetingFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import java.util.List;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.hasItems;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.matchers.arrays.ArraySizeMatcher.hasSize;

/**
 * Created by chicos on 29.04.14.
 * <p/>
 * Smoke-тесты на проверку некоторых методов на production окружении
 * https://jira.yandex-team.ru/browse/TESTIRT-1800
 */
@Aqua.Test
@Features(ApiFeatures.PRODUCTION)
@Stories(RetargetingFeatures.GET_RETARGETING_GOALS)
public class GetRetargetingGoalsProdTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = Logins.CLIENT_SMOKE_PROD;
    private static List<Long> goalsIds;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientLogin);

    @BeforeClass
    public static void initTest() {
        goalsIds = api.userSteps.retargetingSteps().getRetargetingGoalIDs(null);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6689")
    public void requestGoalsByClientLogin() {
        RetargetingGoal[] goals = api.as(clientLogin).userSteps.retargetingSteps().getRetargetingGoals(clientLogin);
        assertThat(extractProperty(goals, RetargetingGoalMap.GOAL_ID), hasItems(goalsIds.toArray()));
        assertThat(goals, hasSize(Matchers.greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6690")
    public void requestGoalsNoRightLoginFieldIgnored() {
        RetargetingGoal[] goals = api.as(clientLogin).userSteps.retargetingSteps().getRetargetingGoals("holodilnik.ru");
        assertThat(extractProperty(goals, RetargetingGoalMap.GOAL_ID), hasItems(goalsIds.toArray()));
        assertThat(goals, hasSize(Matchers.greaterThan(0)));
    }
}
