package ru.yandex.autotests.directapi.retargeting.smoke;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.retargeting.RetargetingFeatures;
import ru.yandex.autotests.directapi.retargeting.RetargetingLogins;
import ru.yandex.autotests.directapi.retargeting.RetargetingStories;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 09.04.13
 */

@Aqua.Test
@Features(RetargetingFeatures.RETARGETING_MONITOR)
@Stories(RetargetingStories.RETARGETING_GOALS)
@RunWith(Parameterized.class)
public class CheckMetrikaGoalsTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Parameterized.Parameter(0)
    public String login;
    @Parameterized.Parameter(1)
    public int goalsMinAmount;

    @Parameterized.Parameters(name = "Login = {0}, Goals min amount = {1}")
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_2, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_3, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_4, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_5, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_6, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_7, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_8, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_9, 2},
                {RetargetingLogins.LOGIN_FOR_RETARGETING_ADD_10, 2},
                {RetargetingLogins.LOGIN_FOR_UAH, 2},
                {RetargetingLogins.LOGIN_FOR_KZT, 2},
                {RetargetingLogins.LOGIN_FOR_RUB, 2},
                {RetargetingLogins.LOGIN_FOR_EUR, 2},
                {RetargetingLogins.LOGIN_FOR_CHF, 2},
                {RetargetingLogins.LOGIN_FOR_TRY, 2},
                {RetargetingLogins.LOGIN_FOR_USD, 2}
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6955")
    public void checkMetrikaGoals() {
        Object[] goals = api.as(login).userSteps.retargetingSteps().getRetargetingGoals(login);
        assertThat("Недостаточное число целей в метрике", goals.length, greaterThanOrEqualTo(goalsMinAmount));
    }

}
