package ru.yandex.autotests.directapi.sandbox;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.AdGroupSubtypeEnum;
import com.yandex.direct.api.v5.ads.AdCategoryEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdSubtypeEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignFundsEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStatusPaymentEnum;
import com.yandex.direct.api.v5.campaigns.CampaignTypeGetEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import com.yandex.direct.api.v5.general.AttributionModelEnum;
import com.yandex.direct.api.v5.general.CurrencyEnum;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import com.yandex.direct.api.v5.vcards.VCardFieldEnum;
import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.matchers.beandiffer2.Api5CompareStrategies;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAssistantMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignFundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingGetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Comparator;
import java.util.List;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by hmepas on 04.09.17
 * https://st.yandex-team.ru/DIRECT-68892
 */

@Aqua.Test
@Features(SandboxFeatures.SANDBOX_MONITOR)
public class SandboxClientDataInitializationTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String login = SandboxLogins.SINGLE_CLIENT_SANDBOX_1;
    private static final String EMAIL = "at-single-sandbox-1@yandex.ru";
    private static final long FUNDS_AMOUNT = 10000000000L;

    private static List<Long> campaignIds;
    private static List<Long> adGroupIds;
    private static List<Long> vcardIds;
    private static List<Long> adIds;

    private static Long[] campaignIdsArray;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandbox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(login, APISandboxClientTypeEnum.CLIENT, true);

        campaignIds = api.as(login).userSteps.campaignSteps().getAllCampaignIds();
        campaignIdsArray = campaignIds.toArray(new Long[3]);
        assumeThat("создано 3 кампании", campaignIds.size(), equalTo(3));

        vcardIds = api.userSteps.vCardsSteps()
                .vCardsGet(new ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap().withFieldNames(
                        VCardFieldEnum.ID)
                ).stream().map(v -> v.getId()).collect(toList());
        assumeThat("создано 3 визитки", vcardIds.size(), equalTo(3));

        adGroupIds = api.as(login).userSteps.adGroupsSteps().adGroupsGet(new ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap()
                .withFieldNames(AdGroupFieldEnum.ID)
                .withSelectionCriteria(new AdGroupsSelectionCriteriaMap().withCampaignIds(campaignIdsArray))
        ).getAdGroups().stream().map(adg -> adg.getId()).collect(toList());
        assumeThat("создано 15 групп", adGroupIds.size(), equalTo(15));

        adIds = api.as(login).userSteps.adsSteps().adsGet(new ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withCampaignIds(campaignIdsArray))
        ).getAds().stream().map(adg -> adg.getId()).collect(toList());
        assumeThat("создано 15 групп", adIds.size(), equalTo(15));
    }

    @Test
    public void checkCampaigns() {
        List<CampaignGetItem> defaultSandboxCampaigns = api.userSteps.campaignSteps().getCampaigns(login);
        // сортируем, т.к. в ответе API настройки идут в случайном порядке
        defaultSandboxCampaigns.forEach(c -> c.getTextCampaign().getSettings().sort(
                Comparator.comparing(s -> s.getOption().toString())
        ));

        assertThat("Создано три кампании с ожидаемыми параметрами", defaultSandboxCampaigns,
                contains(
                        beanDiffer(getSandboxCreatedCampaignBean(1, campaignIds.get(0), StatusEnum.ACCEPTED, CampaignStatusPaymentEnum.ALLOWED, FUNDS_AMOUNT, null))
                                .useCompareStrategy(Api5CompareStrategies.onlyExpectedFields()),
                        beanDifferV5(getSandboxCreatedCampaignBean(2, campaignIds.get(1), StatusEnum.DRAFT, CampaignStatusPaymentEnum.DISALLOWED,0, "Draft")),
                        beanDifferV5(getSandboxCreatedCampaignBean(3, campaignIds.get(2), StatusEnum.DRAFT, CampaignStatusPaymentEnum.DISALLOWED, 0, "Draft"))
                ));
    }

    @Test
    public void checkVCards() {
        final List<VCardGetItem> vcardGetItems = api.userSteps.vCardsSteps()
                .vCardsGet(new ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap().withFieldNames(
                        VCardFieldEnum.class.getEnumConstants())
                );
        BeanDifferMatcher<Object[]> matcher = beanDifferV5(
                new VCardGetItem[]{
                        getSandboxCreatedVCard(vcardIds.get(0), campaignIds.get(0)),
                        getSandboxCreatedVCard(vcardIds.get(1), campaignIds.get(1)),
                        getSandboxCreatedVCard(vcardIds.get(2), campaignIds.get(2))
                }
        );
        matcher.useCompareStrategy(Api5CompareStrategies.allFieldsExcept(BeanFieldPath.newPath("\\d", "pointOnMap")));

        assertThat("созданы визитки с ожидаемыми параметрами", vcardGetItems.toArray(), matcher);
    }

    @Test
    public void checkKeywords() {
        final List<KeywordGetItem> keywordGetItems =
                api.userSteps.keywordsSteps().keywordsGetByCampaignId(login, campaignIdsArray);
        List<Long> keywordIds = keywordGetItems.stream().map(kw -> kw.getId()).collect(toList());
        assumeThat("создано 30 ключевых слов", keywordIds, hasSize(30));
        assertThat("созданы ключевые слова с ожидаемыми параметрами", keywordGetItems.toArray(),
                beanDifferV5(
                        new KeywordGetItem[]{
                                getSandboxCreatedKeyword(keywordIds.get(0), adGroupIds.get(0), campaignIds.get(0), "1.1", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(1), adGroupIds.get(0), campaignIds.get(0), "1.2", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(2), adGroupIds.get(1), campaignIds.get(0), "2.1", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(3), adGroupIds.get(1), campaignIds.get(0), "2.2", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(4), adGroupIds.get(2), campaignIds.get(0), "3.1", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(5), adGroupIds.get(2), campaignIds.get(0), "3.2", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(6), adGroupIds.get(3), campaignIds.get(0), "4.1", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(7), adGroupIds.get(3), campaignIds.get(0), "4.2", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(8), adGroupIds.get(4), campaignIds.get(0), "5.1", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(9), adGroupIds.get(4), campaignIds.get(0), "5.2", StatusEnum.ACCEPTED, StateEnum.ON),
                                getSandboxCreatedKeyword(keywordIds.get(10), adGroupIds.get(5), campaignIds.get(1), "1.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(11), adGroupIds.get(5), campaignIds.get(1), "1.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(12), adGroupIds.get(6), campaignIds.get(1), "2.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(13), adGroupIds.get(6), campaignIds.get(1), "2.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(14), adGroupIds.get(7), campaignIds.get(1), "3.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(15), adGroupIds.get(7), campaignIds.get(1), "3.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(16), adGroupIds.get(8), campaignIds.get(1), "4.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(17), adGroupIds.get(8), campaignIds.get(1), "4.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(18), adGroupIds.get(9), campaignIds.get(1), "5.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(19), adGroupIds.get(9), campaignIds.get(1), "5.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(20), adGroupIds.get(10), campaignIds.get(2), "1.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(21), adGroupIds.get(10), campaignIds.get(2), "1.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(22), adGroupIds.get(11), campaignIds.get(2), "2.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(23), adGroupIds.get(11), campaignIds.get(2), "2.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(24), adGroupIds.get(12), campaignIds.get(2), "3.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(25), adGroupIds.get(12), campaignIds.get(2), "3.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(26), adGroupIds.get(13), campaignIds.get(2), "4.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(27), adGroupIds.get(13), campaignIds.get(2), "4.2", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(28), adGroupIds.get(14), campaignIds.get(2), "5.1", StatusEnum.DRAFT, StateEnum.OFF),
                                getSandboxCreatedKeyword(keywordIds.get(29), adGroupIds.get(14), campaignIds.get(2), "5.2", StatusEnum.DRAFT, StateEnum.OFF)
                        }
                ));
    }

    @Test
    public void checkAdGroups() {
        final List<AdGroupGetItem> actualAdGroups = api.userSteps.adGroupsSteps().adGroupsGet(
                new ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap()
                        .withSelectionCriteria(
                                new AdGroupsSelectionCriteriaMap().withCampaignIds(campaignIdsArray)
                        ).withFieldNames(AdGroupFieldEnum.class.getEnumConstants())
        ).getAdGroups();

        assertThat("созданы группы с ожидаемыми параметрами", actualAdGroups.toArray(),
                beanDifferV5(
                        new AdGroupGetItem[] {
                            getSandboxCreatedAdgroup(campaignIds.get(0), adGroupIds.get(0), StatusEnum.ACCEPTED),
                            getSandboxCreatedAdgroup(campaignIds.get(0), adGroupIds.get(1), StatusEnum.ACCEPTED),
                            getSandboxCreatedAdgroup(campaignIds.get(0), adGroupIds.get(2), StatusEnum.ACCEPTED),
                            getSandboxCreatedAdgroup(campaignIds.get(0), adGroupIds.get(3), StatusEnum.ACCEPTED),
                            getSandboxCreatedAdgroup(campaignIds.get(0), adGroupIds.get(4), StatusEnum.ACCEPTED),
                            getSandboxCreatedAdgroup(campaignIds.get(1), adGroupIds.get(5), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(1), adGroupIds.get(6), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(1), adGroupIds.get(7), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(1), adGroupIds.get(8), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(1), adGroupIds.get(9), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(2), adGroupIds.get(10), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(2), adGroupIds.get(11), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(2), adGroupIds.get(12), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(2), adGroupIds.get(13), StatusEnum.DRAFT),
                            getSandboxCreatedAdgroup(campaignIds.get(2), adGroupIds.get(14), StatusEnum.DRAFT)
                        }
        ));

    }

    @Test
    public void checkAds() {
        final GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withFieldNames(
                        AdFieldEnum.class.getEnumConstants()
                ).withTextAdFieldNames(
                        TextAdFieldEnum.class.getEnumConstants()
                ).withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withCampaignIds(campaignIdsArray)
                )
        );

        assertThat("созданы объявления с ожидаемыми параметрами", getResponse.getAds().toArray(),
                beanDifferV5(
                        new AdGetItem[]{
                                getSandboxCreatedAdBean(1, adIds.get(0), adGroupIds.get(0), campaignIds.get(0), StatusEnum.ACCEPTED,"Accepted at moderation.", vcardIds.get(0), StatusEnum.ACCEPTED, "Contact information accepted at moderation."),
                                getSandboxCreatedAdBean(2, adIds.get(1), adGroupIds.get(1), campaignIds.get(0), StatusEnum.ACCEPTED,"Accepted at moderation.", vcardIds.get(0), StatusEnum.ACCEPTED, "Contact information accepted at moderation."),
                                getSandboxCreatedAdBean(3, adIds.get(2), adGroupIds.get(2), campaignIds.get(0), StatusEnum.ACCEPTED,"Accepted at moderation.", vcardIds.get(0), StatusEnum.ACCEPTED, "Contact information accepted at moderation."),
                                getSandboxCreatedAdBean(4, adIds.get(3), adGroupIds.get(3), campaignIds.get(0), StatusEnum.ACCEPTED,"Accepted at moderation.", vcardIds.get(0), StatusEnum.ACCEPTED, "Contact information accepted at moderation."),
                                getSandboxCreatedAdBean(5, adIds.get(4), adGroupIds.get(4), campaignIds.get(0), StatusEnum.ACCEPTED,"Accepted at moderation.", vcardIds.get(0), StatusEnum.ACCEPTED, "Contact information accepted at moderation."),

                                getSandboxCreatedAdBean(1, adIds.get(5), adGroupIds.get(5), campaignIds.get(1), StatusEnum.DRAFT,"Draft.", vcardIds.get(1), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(2, adIds.get(6), adGroupIds.get(6), campaignIds.get(1), StatusEnum.DRAFT,"Draft.", vcardIds.get(1), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(3, adIds.get(7), adGroupIds.get(7), campaignIds.get(1), StatusEnum.DRAFT,"Draft.", vcardIds.get(1), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(4, adIds.get(8), adGroupIds.get(8), campaignIds.get(1), StatusEnum.DRAFT,"Draft.", vcardIds.get(1), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(5, adIds.get(9), adGroupIds.get(9), campaignIds.get(1), StatusEnum.DRAFT,"Draft.", vcardIds.get(1), StatusEnum.DRAFT, "Draft."),

                                getSandboxCreatedAdBean(1, adIds.get(10), adGroupIds.get(10), campaignIds.get(2), StatusEnum.DRAFT,"Draft.", vcardIds.get(2), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(2, adIds.get(11), adGroupIds.get(11), campaignIds.get(2), StatusEnum.DRAFT,"Draft.", vcardIds.get(2), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(3, adIds.get(12), adGroupIds.get(12), campaignIds.get(2), StatusEnum.DRAFT,"Draft.", vcardIds.get(2), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(4, adIds.get(13), adGroupIds.get(13), campaignIds.get(2), StatusEnum.DRAFT,"Draft.", vcardIds.get(2), StatusEnum.DRAFT, "Draft."),
                                getSandboxCreatedAdBean(5, adIds.get(14), adGroupIds.get(14), campaignIds.get(2), StatusEnum.DRAFT,"Draft.", vcardIds.get(2), StatusEnum.DRAFT, "Draft.")
                        }
                ));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(login);
    }

    private static VCardGetItem getSandboxCreatedVCard(long vcardId, long campaignId) {
        final MapPointMap mapPointMap = new MapPointMap()
                .withX("37.520797").withY("55.770821")
                .withX1("37.516692").withX2("37.524902")
                .withY1("55.768507").withY2("55.773135");

        return (VCardGetItem) new VCardGetMap()
                .withId(vcardId)
                .withCampaignId(campaignId)
                .withCountry("Russia")
                .withCity("Moscow")
                .withStreet("1st street")
                .withHouse("16")
                .withPhone(new PhoneMap().withCountryCode("+7").withCityCode("812").withPhoneNumber("123-45-67"))
                .withCompanyName("Sandbox company")
                .withContactEmail(EMAIL)
                .withWorkTime("0;6;09;00;18;00")
                .withPointOnMap(mapPointMap)
                .withMetroStation(null)
                .withContactPerson(null)
                .withOGRN(null)
                .withBuilding(null)
                .withApartment(null)
                .withInstantMessenger(null)
                .withExtraMessage(null)
                .getBean();
    }

    private static AdGetItem getSandboxCreatedAdBean(int num, long adId, long adgroupId, long campaignId, StatusEnum status, String statusClarification,
            Long vcardId, StatusEnum vcardStatus, String vcardStatusClarification) {
        return (AdGetItem) new AdGetItemMap()
                .withId(adId)
                .withAdGroupId(adgroupId)
                .withCampaignId(campaignId)
                .withStatus(status)
                .withAgeLabel(null)
                .withState(StateEnum.OFF)
                .withAdCategories((AdCategoryEnum) null)
                .withStatusClarification(statusClarification)
                .withType(AdTypeEnum.TEXT_AD)
                .withSubtype(AdSubtypeEnum.NONE)
                .withTextAd(
                        new TextAdGetMap().withText(
                                "Test sandbox banner " + num + " text"
                        ).withTitle(
                                "Test sandbox banner " + num
                        ).withDisplayDomain("www.yandex.ru")
                        .withVideoExtension(null).withAdImageModeration(null).withMobile(YesNoEnum.NO)
                        .withHref("http://www.yandex.ru")
                        .withDisplayUrlPath(null)
                        .withDisplayUrlPathModeration(null)
                        .withSitelinkSetId(null)
                        .withSitelinksModeration(null)
                        .withAdImageHash(null)
                        .withTitle2(null)
                        .withVCardModeration(
                            new ExtensionModerationMap().withStatus(vcardStatus).withStatusClarification(vcardStatusClarification)
                        ).withVCardId(vcardId)
                        .withTurboPageModeration(null)
                        .withTurboPageId(null)
                        .withBusinessId(null)
                        .withPreferVCardOverBusiness(YesNoEnum.NO)
                )
                .getBean();
    }

    private static CampaignGetItem getSandboxCreatedCampaignBean(int campaignNumber, long campaingId, StatusEnum status, CampaignStatusPaymentEnum statusPayment, long fundsAmount, String statusClarification) {
        Long fundsBalance = Money.valueOf(fundsAmount, Currency.RUB).subtractVAT().longValue();
        return (CampaignGetItem) new CampaignGetItemMap().withTextCampaign(
                new TextCampaignGetItemMap()
                        .withRelevantKeywords(
                                new RelevantKeywordsSettingMap()
                                        .withBudgetPercent(50)
                                        .withOptimizeGoalId(0L))
                        .withBiddingStrategy(
                            new TextCampaignStrategyMap().withNetwork(
                                new TextCampaignNetworkStrategyMap().withBiddingStrategyType(
                                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE
                                )
                            ).withSearch(
                                new TextCampaignSearchStrategyMap().defaultHighestPosition()
                            )
                        )
                        .withPriorityGoals((PriorityGoalsItemMap[]) null)
                        .withAttributionModel(AttributionModelEnum.LYDC)
                        .withSettings(
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.ADD_METRICA_TAG).withValue(YesNoEnum.NO),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.ADD_OPENSTAT_TAG).withValue(YesNoEnum.NO),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.ADD_TO_FAVORITES).withValue(YesNoEnum.NO),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED).withValue(YesNoEnum.NO),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED).withValue(YesNoEnum.YES),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING).withValue(YesNoEnum.YES),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.ENABLE_COMPANY_INFO).withValue(YesNoEnum.YES),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.ENABLE_EXTENDED_AD_TITLE).withValue(YesNoEnum.YES),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.ENABLE_SITE_MONITORING).withValue(YesNoEnum.NO),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.EXCLUDE_PAUSED_COMPETING_ADS).withValue(YesNoEnum.NO),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.MAINTAIN_NETWORK_CPC).withValue(YesNoEnum.YES),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.REQUIRE_SERVICING).withValue(YesNoEnum.NO),
                                new TextCampaignSettingGetMap().withOption(TextCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED).withValue(YesNoEnum.NO)
                        ).withCounterIds((Integer[]) null)
        )
                .withId(campaingId)
                .withStatus(status)
                .withSourceId(null)
                .withName("Test API Sandbox campaign " + campaignNumber)
                .withStartDate(
                        LocalDate.now().toString(DateTimeFormat.forPattern("y-MM-dd"))
                )
                .withType(CampaignTypeGetEnum.TEXT_CAMPAIGN)
                .withTimeZone("Europe/Moscow")
                .withState(CampaignStateGetEnum.OFF)
                .withStatusClarification(statusClarification)
                .withCurrency(CurrencyEnum.RUB)
                .withClientInfo("at-single-sandbox-1")
                .withExcludedSites((String[]) null)
                .withStatusPayment(statusPayment)
                .withFunds(
                        new FundsParamMap().withCampaignFunds(new CampaignFundsParamMap()
                                .withBalance(fundsBalance)
                                .withSum(fundsAmount)
                                .withBalanceBonus(0L)
                                .withSumAvailableForTransfer(fundsBalance > 0 ? fundsBalance - 300000000L : 0)
                        ).withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                )
                .withDailyBudget(null)
                .withBlockedIps((String[]) null)
                .withNegativeKeywords("keyword1", "keyword2", "keyword3")
                .withStatistics(new StatisticsMap().withClicks(0L).withImpressions(0L))
                .withEndDate(null)
                .withNotification(new NotificationMap().withSmsSettings(
                        new SmsSettingsMap().withTimeFrom("09:00").withTimeTo("21:00")
                ).withEmailSettings(
                        new EmailSettingsMap()
                                .withEmail(EMAIL)
                                .withSendAccountNews(YesNoEnum.YES)
                                .withWarningBalance(20)
                                .withSendWarnings(YesNoEnum.YES)
                                .withCheckPositionInterval(15)
                ))
                .withTimeTargeting(
                        new TimeTargetingMap()
                                .withSchedule(
                                        "1,0,0,0,0,0,0,0,0,100,100,100,100,100,100,0,100,100,100,100,100,100,0,0,0",
                                        "2,0,0,0,0,0,0,0,0,100,100,100,100,100,100,0,100,100,100,100,100,100,0,0,0",
                                        "3,0,0,0,0,0,0,0,0,100,100,100,100,100,100,0,100,100,100,100,100,100,0,0,0",
                                        "4,0,0,0,0,0,0,0,0,100,100,100,100,100,100,0,100,100,100,100,100,100,0,0,0",
                                        "5,0,0,0,0,0,0,0,0,100,100,100,100,100,100,0,100,100,100,100,100,100,0,0,0",
                                        "6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0",
                                        "7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"
                                )
                                .withConsiderWorkingWeekends(YesNoEnum.YES).withHolidaysSchedule(null)
                ).withRepresentedBy(
                        new CampaignAssistantMap().withAgency(null).withManager(null)
                )
                .getBean();
    }

    private static AdGroupGetItem getSandboxCreatedAdgroup(long campaignId, long adGroupId, StatusEnum status) {
        return (AdGroupGetItem) new AdGroupGetItemMap()
                .withId(adGroupId)
                .withCampaignId(campaignId)
                .withStatus(status)
                .withName("Группа №" + adGroupId)
                .withRegionIds(1L)
                .withRestrictedRegionIds((Long[]) null)
                .withType(AdGroupTypesEnum.TEXT_AD_GROUP)
                .withNegativeKeywords(
                        "minusword1",
                        "minusword2",
                        "minusword3"
                ).withSubtype(AdGroupSubtypeEnum.NONE)
                .withTrackingParams("")
                .withServingStatus(ServingStatusEnum.ELIGIBLE)
                .withNegativeKeywordSharedSetIds(null)
                .getBean();
    }

    private static KeywordGetItem getSandboxCreatedKeyword(long keywordId, long adgroupId, long campaignId, String index, StatusEnum status, StateEnum state) {
        StatisticsMap emptyStatistics = new StatisticsMap().withClicks(0L).withImpressions(0L);
        return (KeywordGetItem) new KeywordGetItemMap()
                .withCampaignId(campaignId)
                .withAdGroupId(adgroupId)
                .withId(keywordId)
                .withKeyword("test keyword " + index)
                .withStrategyPriority(PriorityEnum.NORMAL)
                .withBid(300_000L)
                .withContextBid(300_000L)
                .withServingStatus(ServingStatusEnum.ELIGIBLE)
                .withStatus(status)
                .withState(state)
                .withProductivity(null)
                .withStatisticsNetwork(emptyStatistics)
                .withStatisticsSearch(emptyStatistics)
                .withUserParam1(null)
                .withUserParam2(null)
                .getBean();
    }
}
