package ru.yandex.autotests.directapi.sandbox;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


/**
 * Created by chicos on 21.05.14.
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-1980
 */

@Aqua.Test
@Features(SandboxFeatures.SANDBOX_MONITOR)
public class SandboxSmokeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = SandboxLogins.SINGLE_CLIENT_SANDBOX_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandbox() {
        api.userSteps.sandboxSteps().enableSandbox(login, APISandboxClientTypeEnum.CLIENT, true);
    }

    @Test
    public void simpleSandboxTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        assertThat("удалось создать кампанию", campaignId, not(equalTo(0)));
        api.userSteps.campaignSteps().campaignsDelete(campaignId);
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(login);
    }
}
